package com.hand.app.faceCard.controllers;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.faceCard.dto.FaceCard;
import com.hand.app.faceCard.service.IFaceCardService;
import com.hand.hap.system.controllers.BaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;


@Controller
@RequestMapping(value = {"/r/api", "/"})
public class FaceCardController extends BaseController {

    @Autowired
    private IFaceCardService faceService;
    private Logger logger = LoggerFactory.getLogger(getClass());

    @ResponseBody
    @RequestMapping("/app/faceCard/verify")
    public JSONObject verify(HttpServletRequest request, @RequestBody FaceCard faceCard) {
        JSONObject json = new JSONObject();
        try {
            json = faceService.faceCheck(createRequestContext(request), faceCard);
        } catch (Exception e) {
            logger.error("something error!", e);
            json.put("code", "E");
            json.put("message", "人证对比失败");
        }
        return json;
    }


}
