package com.hand.app.esignHclc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.esignHclc.dto.SignUserInfoHclc;
import com.hand.app.esignHclc.dto.SignUserFaceHclc;
import com.hand.app.esignHclc.mapper.SignInfoHclcMapper;
import com.hand.app.esignHclc.service.IOrganSignInfoHclcService;
import com.hand.app.esignHclc.service.ISignInfoHclcFaceService;
import com.hand.app.esignHclc.service.ISignInfoHclcService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;


/**
 * Created with IntelliJ IDEA.
 * User: lsy
 * Date: 2020/2/24
 * Time: 9:08
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class SignInfoHclcFaceServiceImpl extends BaseServiceImpl<SignUserFaceHclc> implements ISignInfoHclcFaceService {

    private final Object lock = new Object();
    @Autowired
    private ISignInfoHclcService iSignInfoHclcService;
    @Autowired
    private SignInfoHclcMapper signInfoHclcMapper;
    @Autowired
    private IOrganSignInfoHclcService iOrganSignInfoHclcService;

    private Logger logger = LoggerFactory.getLogger(getClass());

    public void postAuthResult(IRequest iRequest, JSONObject params) {
        logger.info("认证结果通知信息 params: {}", params.toJSONString());
        synchronized (lock) {

            if (Objects.isNull(params.get("contextId"))) {
                return;
            }

            SignUserFaceHclc signInfoHclcFace = new SignUserFaceHclc();
            signInfoHclcFace.setAuthId(Long.valueOf(params.get("contextId").toString()));
            signInfoHclcFace = this.selectByPrimaryKey(iRequest, signInfoHclcFace);

            //判断认证识别流程是否存在
            if (Objects.nonNull(signInfoHclcFace) && !"SUCCESS".equalsIgnoreCase(signInfoHclcFace.getAuthStatus()) && Objects.nonNull(params.get("verifycode"))) {

                //判断认证返回结果成功
                if ("true".equalsIgnoreCase(params.get("success").toString())) {
                    //更新认证明细表状态
                    signInfoHclcFace.setAuthStatus("SUCCESS");
                    signInfoHclcFace.setVerifyCode(params.get("verifycode").toString());

                    SignUserInfoHclc signInfoHclc = new SignUserInfoHclc();
                    signInfoHclc.setOpenId(signInfoHclcFace.getOpenId());
                    signInfoHclc = iSignInfoHclcService.selectByPrimaryKey(iRequest, signInfoHclc);
                    //更新用户认证状态为Y--modify by lsy 20200813调整
                    if (signInfoHclc.getCtitype().compareTo(1L) == 0) {
                        signInfoHclc.setAuthFlag("Y");

                    } else if (signInfoHclc.getCtitype().compareTo(2L) == 0) {

                        //获取已注册企业认证信息
                        SignUserInfoHclc managerSignInfo = new SignUserInfoHclc();
                        managerSignInfo.setIdNo(signInfoHclc.getIdNo());
                        managerSignInfo.setIsManagerFlag("Y");
                        managerSignInfo.setAuthFlag("Y");
                        List<SignUserInfoHclc> managerList = signInfoHclcMapper.select(managerSignInfo);
                        //存在已注册企业认证信息，更新当前用户信息
                        if (Objects.nonNull(managerList) && managerList.size() > 0) {
                            managerSignInfo = managerList.get(0);
                            signInfoHclc.setAccountId(managerSignInfo.getAccountId());
                            signInfoHclc.setOrgAuthId(managerSignInfo.getOrgAuthId());
                        }

                        if ("N".equalsIgnoreCase(signInfoHclc.getIsManagerFlag()) || "2".equalsIgnoreCase(signInfoHclcFace.getAuthType()) || (Objects.nonNull(managerList) && managerList.size() > 0)) {
                            signInfoHclc.setAuthFlag("Y");
                        }
                        //企业认证成功新增一条对应个人信息
                        if ("Y".equalsIgnoreCase(signInfoHclc.getAuthFlag())) {
                            iOrganSignInfoHclcService.createOrgPersonInfo(signInfoHclc.getOpenId());
                        }
                    }
                    iSignInfoHclcService.updateByPrimaryKeySelective(iRequest, signInfoHclc);

                } else {
                    //更新认证明细表状态
                    signInfoHclcFace.setAuthStatus("FAIL");
                    signInfoHclcFace.setVerifyCode(params.get("verifycode").toString());
                }
                this.updateByPrimaryKey(iRequest, signInfoHclcFace);
            }
        }
    }
}
