package com.hand.hap.security;

import com.hand.hap.mybatis.util.StringUtil;
import com.hand.hls.utils.RSACoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;



public class RSAPasswordManager extends PasswordManager {
    public static Logger logger = LoggerFactory.getLogger(RSAPasswordManager.class);

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        if (StringUtil.isEmpty(encodedPassword))
            return false;
        try {
            CharSequence decrypt = RSACoder.encryptByPrivateKey(rawPassword);
            return super.matches(decrypt, encodedPassword);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("decrypt password failed ,the exception is {}", e);
            return false;
        }
    }
}
