package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.ScreenBuilder;
import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;

import java.util.List;

/**
 * 
 * 
 * 
 * @author yang.gao01@hand-china.com
 * 
 */
@UITag
public class HlsHBox extends Component {
	public static final String PROPERTITY_HLSHBOX = "hlsHBox";
	public static final String PROPERTITY_HLSHBOXBODY = "hlsHBoxBody";
	public static final String PROPERTITY_HLSCLASSNAME = "hlsClassName";
	public static final String PROPERTITY_STYLE = "style";
	public static final String PROPERTITY_BOXTYPE = "boxType";
	
	public String getHBoxBody(ViewContext context) throws Exception {
		StringBuffer sb = new StringBuffer();
		List<XMap> list = getPrototype().getChildren();
		for (XMap map : list) {
			sb.append(ScreenBuilder.build(map, context));
		}
		return sb.toString();
	}
	public void setHlsClassName(String hlsClassName) {
		setPropertity(PROPERTITY_HLSCLASSNAME, hlsClassName);
	}
	public String getHlsClassName() {
		return getPrototype().getString(PROPERTITY_HLSCLASSNAME);
	}
	public String getBoxType() {
		return getPrototype().getString(PROPERTITY_BOXTYPE);
	}

	public static HlsHBox createInstance() {
		XMap view = new XMap(DEFAULT_TAG_PREFIX, DEFAULT_NAME_SPACE,
				PROPERTITY_HLSHBOX);
		HlsHBox HlsHBox = new HlsHBox();
		HlsHBox.initPrototype(view);
		return HlsHBox;
	}
	
	public void init(XMap view, ViewContext context) throws Exception {
		super.init(view, context);
		context.put(PROPERTITY_HLSHBOXBODY, getHBoxBody(context));
		context.put(PROPERTITY_STYLE, getStyle());
		context.put(PROPERTITY_HLSCLASSNAME, getHlsClassName());
		context.put(PROPERTITY_BOXTYPE, getBoxType());
	}

}
