package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;

@UITag
public class HlsFoldLineChart extends HlsMultiBarChart{
    public static final String PROPERTITY_HLSCOUNTCHART= "HlsSelectBar";
    public static final String PROPERTITY_STYLE = "style";
    public static final String PROPERTITY_COLOR = "color";
    public static final String PROPERTITY_TITLEID = "titleId";
    public static final String PROPERTITY_CHARTID = "chartId";
    public static final String SHOW_TITLE = "showTitle";

    public String getStyle(){return this.getPrototype().getString(PROPERTITY_STYLE);}
    public String getColor(){return this.getPrototype().getString(PROPERTITY_COLOR);}
    public String getTitleId(){return this.getPrototype().getString(PROPERTITY_TITLEID);}
    public String getChartId(){return this.getPrototype().getString(PROPERTITY_CHARTID);}
    public String getShowTitle(){return this.getPrototype().getString(SHOW_TITLE);}


    public static HlsFoldLineChart createInstance() {
        XMap view = new XMap(DEFAULT_TAG_PREFIX, DEFAULT_NAME_SPACE, PROPERTITY_HLSCOUNTCHART);
        HlsFoldLineChart hlsFoldLineChart = new HlsFoldLineChart();
        hlsFoldLineChart.initPrototype(view);
        return hlsFoldLineChart;
    }
    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.put(PROPERTITY_STYLE,getStyle());
        context.put(PROPERTITY_COLOR,getColor());
//        context.addJsonConfig("color",getColor());
        context.put(PROPERTITY_TITLEID,getTitleId());
        context.addJsonConfig("titleId",getTitleId());
        context.put(PROPERTITY_CHARTID,getChartId());
        context.addJsonConfig("chartId",getChartId());
        context.put(SHOW_TITLE,getShowTitle());
    }
}
