package com.hand.app.zhongDengWang.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.hand.app.zhongDengWang.dto.*;
import com.hand.app.zhongDengWang.mapper.*;
import com.hand.app.zhongDengWang.service.IFndZhongDengHeadsService;
import com.hand.app.zhongDengWang.service.IFndZhongDengLinesService;
import com.hand.app.zhongDengWang.service.IZdwNewWsRequestsService;
import com.hand.app.zhongDengWang.service.IZdwWsRequestsService;
import com.hand.app.zhongDengWang.utils.ClientUtils;
import com.hand.app.zhongDengWang.ws.amend.WSAmendRegisterService;
import com.hand.app.zhongDengWang.ws.amend.WSAmendRegisterServiceService;
import com.hand.app.zhongDengWang.ws.extend.WSExtendRegisterService;
import com.hand.app.zhongDengWang.ws.extend.WSExtendRegisterServiceService;
import com.hand.app.zhongDengWang.ws.init.WSInitRegisterService;
import com.hand.app.zhongDengWang.ws.init.WSInitRegisterServiceService;
import com.hand.app.zhongDengWang.ws.login.WSLoginService;
import com.hand.app.zhongDengWang.ws.login.WSLoginServiceService;
import com.hand.app.zhongDengWang.ws.terminate.WSTerminateRegisterService;
import com.hand.app.zhongDengWang.ws.terminate.WSTerminateRegisterServiceService;
import com.hand.hap.core.IRequest;
import com.hand.hap.lock.components.DatabaseLockProvider;
import com.hand.hap.system.dto.DTOStatus;
import com.rfp.sm.utils.SM2Utils;
import com.rfp.sm.utils.SM3Utils;
import org.apache.commons.lang3.StringUtils;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Service
public class ZdwNewWsRequestsServiceImpl implements IZdwNewWsRequestsService {

    @Autowired
    ZdwLoginTokenInterfaceMapper zdwLoginTokenInterfaceMapper;
    @Autowired
    FndZhongDengHeadsMapper fndZhongDengHeadsMapper;
    @Autowired
    FndZhongDengLinesMapper fndZhongDengLinesMapper;
    @Autowired
    IFndZhongDengHeadsService fndZhongDengHeadsService;
    @Autowired
    IFndZhongDengLinesService fndZhongDengLinesService;
    @Autowired
    IZdwWsRequestsService zdwWsRequestsService;
    @Autowired
    HlsWsRequestsMapper hlsWsRequestsMapper;
    @Autowired
    FndAtmAttachmentMapper fndAtmAttachmentMapper;
    @Autowired
    FndZhongDengBatchMapper fndZhongDengBatchMapper;
    @Autowired
    private DatabaseLockProvider databaseLockProvider;


    private Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
     * Use private final lock objects to synchronize classes that may interact with untrusted code
     */
    private final Object lock = new Object();


    @Value("${zdw.login.clientKey}")
    private String clientKey;
    @Value("${zdw.login.userName}")
    private String userName;
    @Value("${zdw.login.password}")
    private String userPassword;
    @Value("${zdw.login.authCode}")
    private String authCode;
    @Value("${zdw.request.url.init}")
    private String initUrl;
    @Value("${zdw.request.url.renewal}")
    private String renewalUrl;
    @Value("${zdw.request.url.cancel}")
    private String cancelUrl;

    private String loginToken;



    private HlsWsRequests createRequestLog(String url, String requestClob, Long pkValue) {
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests.setRequestDate(new Date());
        hlsWsRequests.setRequestWsdlUrl(url);
        hlsWsRequests.setFunctionName("INIT_REGISTER");
        hlsWsRequests.setRequestJson(requestClob);
        hlsWsRequests.setStatusDate(new Date());
        hlsWsRequests.setParameterType("json");
        hlsWsRequests.setPkValue(pkValue);

        hlsWsRequestsMapper.insertSelective(hlsWsRequests);
        return hlsWsRequests;
    }

    /**
     * 设置错误信息
     *
     * @param resultJson    返回给前端的结果集
     * @param hlsWsRequests 储存给数据库的请求体
     * @param e             异常
     */
    public void setErrData(JSONObject resultJson, HlsWsRequests hlsWsRequests, Exception e) {
        resultJson.put("code", "-1");
        resultJson.put("info", "请求失败：" + e.getMessage());
        hlsWsRequests.setReturnStatus("E");
        hlsWsRequests.setResponsedDate(new Date());
    }

    /**
     * 设置返回信息
     *
     * @param resultJson    返回给前端的结果集
     * @param hlsWsRequests 储存给数据库的请求体
     * @param resData       返回字符串
     */
    public void setResData(JSONObject resultJson, HlsWsRequests hlsWsRequests, String resData) {
        resultJson.put("code", "0");
        resultJson.put("info", resData);
        hlsWsRequests.setReturnStatus("S");
        hlsWsRequests.setResponseClob(resData);
        hlsWsRequests.setResponsedDate(new Date());
    }

    private String sendPostRequest(String url,String data) throws Exception{
        //修改请求json中的账户信息字段,确定只有一个元素
        JSONArray requestJson = JSONArray.parseArray(data);
        JSONObject jsonObject = requestJson.getJSONObject(0);
        String encryptPassword = SM3Utils.toHash(userPassword);
        jsonObject.put("username",userName);
        jsonObject.put("password",encryptPassword);
        jsonObject.put("platformAuthCode",authCode);
        String param = Base64.getEncoder().encodeToString(requestJson.toJSONString().getBytes("utf-8"));
        /*发送初始登记接口请求*/
        JSONObject reqParam = new JSONObject();
        reqParam.put("data",param);
        URL urlObj = new URL(url);
        System.out.println(jsonObject.toJSONString());
        System.out.println(param);
        HttpURLConnection connection = (HttpURLConnection) urlObj.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        OutputStream outputStream = connection.getOutputStream();
        outputStream.write(reqParam.toJSONString().getBytes());
        outputStream.flush();

        int statusCode = connection.getResponseCode();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String inputLine;
        StringBuilder responseBody = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            responseBody.append(inputLine);
        }
        in.close();
        String res = new String(Base64.getDecoder().decode(responseBody.toString()));
        System.out.println("Response Code: " + statusCode);
        System.out.println("Response Body: " + res);
        connection.disconnect();
        return  res;
    }

    /*初始登记*/
    public JSONObject registerRequest( FndZhongDengLines line) {
        JSONObject resultJson = new JSONObject();

        String requestJsonContent = line.getRequestJson();
        /*插入接口日志表*/
        HlsWsRequests hlsWsRequests = new HlsWsRequests();

        String requestUrl = "";
        switch (line.getUpStage()){
            case "01" : requestUrl = initUrl;break;
            case "03" : requestUrl = renewalUrl;break;
            case "05" : requestUrl = cancelUrl;break;
            default: requestUrl = null;
        }

        if (StringUtils.isEmpty(requestUrl)){
            Exception e = new Exception("找不到登记类型");
            setErrData(resultJson, hlsWsRequests, e);
        }

        hlsWsRequests = createRequestLog(requestUrl,requestJsonContent , line.getLineId());
        try {

            String resData = sendPostRequest(requestUrl, line.getRequestJson());
            setResData(resultJson, hlsWsRequests, resData);
            System.out.println(resData);
            logger.info("register init success line_id:{}, returns: {}", line.getLineId(), resData);
        } catch (Exception e) {
            e.printStackTrace();
            setErrData(resultJson, hlsWsRequests, e);
            logger.info("register init fail line_id:{},message: {}", line.getLineId(), e.getMessage());
        }

        hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        return resultJson;
    }

    /***
     * 融资租赁-登记入口方法;
     * @param
     * @param
     ***/
    public void registerThread(IRequest request, List<FndZhongDengBatch> fndZhongDengBatches, String loginToken) {
        JSONObject resultJson = new JSONObject();
        List<FndZhongDengLines> fndZhongDengLinesList = new ArrayList<>();
        List<FndZhongDengHeads> fndZhongDengHeadsList = new ArrayList<>();
        /*根据传入ids循环上报中登网*/
        synchronized (lock) {
            for (FndZhongDengBatch batch : fndZhongDengBatches) {
                /*根据批次id获取该批次下所有上报行id*/
                FndZhongDengLines fndZhongDengLines = new FndZhongDengLines();
                fndZhongDengLines.setLineId(batch.getLineId());
                fndZhongDengLines = fndZhongDengLinesMapper.selectByPrimaryKey(fndZhongDengLines);


                if (Objects.nonNull(fndZhongDengLines) && "UPING".equalsIgnoreCase(fndZhongDengLines.getUpStatus()) && "NORMAL".equalsIgnoreCase(fndZhongDengLines.getDataClass())) {
                    try {
                        FndZhongDengHeads fndZhongDengHeads = new FndZhongDengHeads();
                        fndZhongDengHeads.setHeadId(fndZhongDengLines.getHeadId());
                        fndZhongDengHeads = fndZhongDengHeadsMapper.selectByPrimaryKey(fndZhongDengHeads);

                        /*初始登记*/
                        resultJson = registerRequest(fndZhongDengLines);


                        /*解析接口返回结果*/
                        JSONObject returnJson = JSONObject.parseObject(resultJson.getString("info"));

                        String registerResult = returnJson.getString("regResult");

                        /*成功*/
                        if (Objects.nonNull(registerResult) && "001".equalsIgnoreCase(registerResult)) {

                            /*回写登记报文号registernumber*/
                            if (!StringUtils.isEmpty(returnJson.getString("registerNo"))) {
                                String registerNumber = returnJson.getString("registerNo");
                                fndZhongDengLines.setRegisterNumber(registerNumber);
                                
                                /*初始登记*/
                                if ("01".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                                    fndZhongDengHeads.setInitRegisterNumber(registerNumber);
                                } else if ("02".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                                    fndZhongDengHeads.setAmendRegisterNumber(registerNumber);
                                } else if ("03".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                                    fndZhongDengHeads.setExtendRegisterNumber(registerNumber);
                                } else if ("05".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                                    fndZhongDengHeads.setAbolishRegisterNumber(registerNumber);
                                }
                            }
                            /*回写修改码authorizationcode*/
                            if (!StringUtils.isEmpty(returnJson.getString("authorizationCode"))) {
                                String authorizationCode = returnJson.getString("authorizationCode");
                                fndZhongDengLines.setAuthorizationCode(authorizationCode);
                                fndZhongDengHeads.setAuthorizationCode(authorizationCode);
                            }
                            fndZhongDengHeads.set__status(DTOStatus.UPDATE);
                            fndZhongDengHeadsList.add(fndZhongDengHeads);
                            fndZhongDengLines.setUpStatus("SUCCESS");
                            fndZhongDengLines.setReturnMsg("上报成功");
                            /*失败*/
                        } else {
                            String error = returnJson.getJSONArray("errors").toJSONString();
                            fndZhongDengLines.setUpStatus("FAIL");
                            fndZhongDengLines.setReturnMsg(error);
                        }

                    } catch (RuntimeException e) {
                        e.printStackTrace();
                        fndZhongDengLines.setUpStatus("FAIL");
                        fndZhongDengLines.setReturnMsg(e.getMessage());
                    } catch (Exception e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                        fndZhongDengLines.setUpStatus("FAIL");
                        fndZhongDengLines.setReturnMsg(e.getMessage());
                    }
                    fndZhongDengLines.setUpDate(new Date());
                    fndZhongDengLines.set__status(DTOStatus.UPDATE);
                    fndZhongDengLinesList.add(fndZhongDengLines);
                }
            }

            if (fndZhongDengHeadsList.size() > 0) {
                fndZhongDengHeadsService.batchUpdate(request, fndZhongDengHeadsList);
            }
            if (fndZhongDengLinesList.size() > 0) {
                fndZhongDengLinesService.batchUpdate(request, fndZhongDengLinesList);
            }
        }
    }

    /***
     * 融资租赁-登记入口方法;
     * @param request
     * @param params
     ***/
    @Override
    public JSONObject initRegisterService(IRequest request, JSONObject params) {
        JSONObject resultJson = new JSONObject();

        Long batchId=params.getLongValue("batchId");
        if(Objects.isNull(batchId)){
            resultJson.put("code", "001");
            resultJson.put("info", "必须传入参数batchId缺失，请检查");
            return resultJson;
        }

        /*根据批次ID获取所有上报请求id*/
        List<FndZhongDengBatch> fndZhongDengBatches = new ArrayList<>();
        FndZhongDengBatch fndZhongDengBatch = new FndZhongDengBatch();
        fndZhongDengBatch.setBatchId(batchId);
        fndZhongDengBatches = fndZhongDengBatchMapper.select(fndZhongDengBatch);


        if (fndZhongDengBatches.size() == 0) {
            resultJson.put("code", "000");
            resultJson.put("info", "000");
            return resultJson;
        }

        final List<FndZhongDengBatch> fndZhongDengBatchList = fndZhongDengBatches;
        /*启用新线程进行异步处理中登网接口请求*/
        ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
        cachedThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                // do
                try {
                    registerThread(request, fndZhongDengBatchList, loginToken);
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });
        /*关闭线程*/
        cachedThreadPool.shutdown();
        resultJson.put("code", "000");
        resultJson.put("info", "000");

        return resultJson;
    }


}