package com.hand.app.sms.controllers;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.sms.service.IHclcSmsService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * Copyright (C) Hand Business Consulting Services
 * AllRights Reserved
 *
 * @author: Eugene Song
 * @date: 2023/6/12
 * @description:
 */
@Controller
public class HclcSmsController extends BaseController {

    @Autowired
    private IHclcSmsService hclcSmsService;

    @ResponseBody
    @RequestMapping("/api/public/send/sms")
    public JSONObject sendSms(HttpServletRequest request, @RequestBody(required = true) JSONObject params) {
        IRequest iRequest = createRequestContext(request);
        JSONObject json = hclcSmsService.sendSms(iRequest, params);
        return json;
    }
}
