package com.hand.app.qcc.service.impl;


import com.hand.app.esignHclc.dto.Lm005Hclc;
import com.hand.app.esignHclc.mapper.Lm005HclcMapper;
import com.hand.app.qcc.service.IQccRequestsService;
import com.hand.app.zhongDengWang.dto.HlsWsRequests;
import com.hand.app.zhongDengWang.mapper.HlsWsRequestsMapper;
import com.hand.hap.core.IRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import static java.lang.System.out;


import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

import org.apache.http.client.methods.HttpHead;
import org.json.JSONException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;



@Service
public class QccRequestsServiceImpl implements IQccRequestsService {

    @Autowired
    HlsWsRequestsMapper hlsWsRequestsMapper;

    @Autowired
    private Lm005HclcMapper lm005HclcMapper;

    @Value("${qcc.api.app.key}")
    private String appkey;
    @Value("${qcc.api.secret.key}")
    private String secretKey;
    @Value("${qcc.api.url}")
    private String reqInterName;

    @Override
    public JSONObject qccQueryService(IRequest request, JSONObject params) {
        String status;
        String ctino = params.getString("keyword");
        String reqUri = reqInterName.concat("?key=").concat(appkey).concat("&keyword=").concat(ctino);
        String tokenJson = getJson(reqUri, ctino);
        status = FormartJson(tokenJson, "Status");
        if (!HttpCodeRegex.isAbnornalRequest(status)) {
            PrettyPrintJson(tokenJson);
        }
        updateLm005Hclc(tokenJson, ctino);
        return new JSONObject(tokenJson);
    }

    private void updateLm005Hclc(String tokenJson, String ctino) {
//        List<Map<String, Object>> maps = lm005HclcMapper.selectOneByCtino(ctino);
        String registCapi = FormartJson(tokenJson, "RegistCapi");
        if (Objects.nonNull(registCapi)) {
            lm005HclcMapper.updateByCtino(ctino, registCapi);
        }
    }
    private String getJson(String url, String paramStr) {
        JSONObject json = new JSONObject();
        json.put("keyword", paramStr);
        HlsWsRequests hlsWsRequests = createRequestLog(url, json.toString());
        String dataJson = null;
        try {
            dataJson = sendGetRequest(url);
            setResData(hlsWsRequests, dataJson);
        } catch (Exception e) {
            e.printStackTrace();
            setErrData(hlsWsRequests, e);
        }
        hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        return dataJson;
    }

    private String sendGetRequest(String url) throws IOException {
        String[] autherHeader = RandomAuthentHeader();
        URL urlObj = new URL(url);
        HttpURLConnection connection = (HttpURLConnection) urlObj.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Token", autherHeader[0]);
        connection.setRequestProperty("Timespan", autherHeader[1]);
        connection.setDoOutput(true);
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String inputLine;
        StringBuilder responseBody = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            responseBody.append(inputLine);
        }
        in.close();
        connection.disconnect();
        return responseBody.toString();
    }

    // 获取返回码 Res Code
    static class HttpCodeRegex {
        private static final String ABNORMAL_REGIX = "(101)|(102)";
        private static final Pattern pattern = Pattern.compile(ABNORMAL_REGIX);
        protected static boolean isAbnornalRequest(final String status) {
            return pattern.matcher(status).matches();
        }
    }

    // 获取Auth Code
    private String[] RandomAuthentHeader() {
        String timeSpan = String.valueOf(System.currentTimeMillis() / 1000);
        String[] authentHeaders = new String[] { DigestUtils.md5Hex(appkey.concat(timeSpan).concat(secretKey)).toUpperCase(), timeSpan };
        return authentHeaders;
    }

    // 解析JSON
    private String FormartJson(String jsonString, String key) throws JSONException {
        JSONObject jObject = new JSONObject(jsonString);
        return (String) jObject.get(key);
    }

    // 日志保存
    private HlsWsRequests createRequestLog(String url, String requestClob) {
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests.setRequestDate(new Date());
        hlsWsRequests.setRequestWsdlUrl(url);
        hlsWsRequests.setFunctionName("QCC_QUERY");
        hlsWsRequests.setRequestJson(requestClob);
        hlsWsRequests.setStatusDate(new Date());
        hlsWsRequests.setParameterType("json");

        hlsWsRequestsMapper.insertSelective(hlsWsRequests);
        return hlsWsRequests;
    }

    // 设置信息
    public void setResData(HlsWsRequests hlsWsRequests, String resData) {
        hlsWsRequests.setReturnStatus("S");
        hlsWsRequests.setResponseJson(resData);
        hlsWsRequests.setResponsedDate(new Date());
    }

    // 设置错误信息
    public void setErrData(HlsWsRequests hlsWsRequests, Exception e) {
        hlsWsRequests.setReturnStatus("F");
        hlsWsRequests.setResponsedDate(new Date());
        hlsWsRequests.setResponseJson(e.getMessage());
    }

    // pretty print 返回值
    protected static void PrettyPrintJson(String jsonString) throws JSONException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Object obj = mapper.readValue(jsonString, Object.class);
            String indented = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
            out.println(indented);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}