
package com.hand.app.qcc.controllers;


import com.hand.app.qcc.service.IQccRequestsService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

@Controller
@RequestMapping(value = {"/r/api", "/"})
public class QccRequestsController extends BaseController {

    @Autowired
    private IQccRequestsService service;


    /**
     * 中登网融资租赁-登记入口
     **/
    @RequestMapping(value = "/qcc/service/query")
    @ResponseBody
    public JSONObject initRegister(HttpServletRequest request, @RequestBody(required = true) JSONObject params) {
        IRequest requestContext = createRequestContext(request);
        return service.qccQueryService(requestContext, params);
    }

}