package com.hand.app.pingAn.utils;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.cmb.service.impl.HclcCmbPolyServiceImpl;
import com.hand.app.cmb.util.Utils;
import com.pingan.openbank.api.sdk.client.ApiClient;
import com.pingan.openbank.api.sdk.common.http.HttpResult;
import com.pingan.openbank.api.sdk.entity.*;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class ApiUtils {
    private static ApiClient apiClient = ApiClient.getInstance("pingAn.properties");
    private static JSONObject baseReqBody  = new JSONObject();
    private static Calendar cal = null;
    private static SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static Properties pro = null;
    private static String MrchCode;
    public static String AcctNo;
    static{
        String path = Thread.currentThread().getContextClassLoader().getResource("").getPath().substring(1);
        pro = Utils.loadProp(path + "pingAn.properties");
        if (Objects.isNull(pro)) {
            LoggerFactory.getLogger(HclcCmbPolyServiceImpl.class).error("配置文件初始化异常");
        }
        // todo 设置通用的请求参数，比如主账号，流水号，企业银企直连标准代码等
        MrchCode = pro.getProperty("MrchCode");
        AcctNo = pro.getProperty("AcctNo");
        baseReqBody.put("MrchCode",MrchCode);
        baseReqBody.put("MainAccount",AcctNo);
    }

    public static HttpResult invoke(String interfaceName,JSONObject requestBody){
        SdkRequest sdkRequest = new SdkRequest();
        sdkRequest.setInterfaceName("V1.0/"+interfaceName);
        sdkRequest.setBody(requestBody);
        return apiClient.invoke(sdkRequest);
    }

    public static JSONObject getBaseReqBody(){
        JSONObject clone = baseReqBody.clone();
        cal = Calendar.getInstance();
        String today = df.format(cal.getTime());
        clone.put("CnsmrSeqNo",today+"000");
        return clone;
    }

    public static ApiClient getApiClient(){
        return apiClient;
    }
}
