package com.hand.app.pingAn.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinapay.comm.Constants;
import com.chinapay.dto.HlsEbankCcbAccount;
import com.chinapay.dto.HlsEbankCcbTransaction;
import com.chinapay.mapper.HlsEbankCcbAccountMapper;
import com.chinapay.mapper.HlsEbankCcbTransactionMapper;
import com.chinapay.service.IHlsEbankCcbAccountService;
import com.chinapay.service.IHlsEbankCcbTransactionService;
import com.chinapay.service.impl.HlsEbankCcbTransactionServiceImpl;
import com.chinapay.util.StringUtil;
import com.hand.app.cmb.dto.Ld037;
import com.hand.app.cmb.service.impl.HclcCmbPolyServiceImpl;
import com.hand.app.cmb.service.impl.HlsEbankCmbTransqryServiceImpl;
import com.hand.app.cmb.util.Utils;
import com.hand.app.esignHclc.utils.SignHclcUtils;
import com.hand.app.pingAn.service.PingAnService;
import com.hand.app.pingAn.utils.ApiUtils;
import com.hand.app.zhongDengWang.dto.HlsWsRequests;
import com.hand.app.zhongDengWang.mapper.HlsWsRequestsMapper;
import com.hand.hap.core.IRequest;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.dto.ResponseData;
import com.pingan.openbank.api.sdk.client.ApiClient;
import com.pingan.openbank.api.sdk.common.http.HttpResult;
import com.pingan.openbank.api.sdk.entity.*;
import com.pingan.openbank.api.sdk.exception.OpenBankSdkException;
import com.pingan.openbank.api.sdk.exception.OpenBankSdkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class PingAnServiceImpl implements PingAnService {

    @Autowired
    private HlsWsRequestsMapper hlsWsRequestsMapper;
    @Autowired
    private IHapInterfaceHeaderService headerService;
    @Autowired
    private IHlsEbankCcbTransactionService hlsEbankCcbTransactionService;
    @Autowired
    private HlsEbankCcbTransactionMapper hlsEbankCcbTransactionMapper;
    @Autowired
    private DataSourceTransactionManager transactionManager;
    @Autowired
    private IHlsEbankCcbAccountService hlsEbankCcbAccountService;
    @Autowired
    private HlsEbankCcbAccountMapper hlsEbankCcbAccountMapper;

    private Logger logger = LoggerFactory.getLogger(getClass());

    private static JSONObject baseReqBody = new JSONObject();

    private static Properties pro = null;
    private static Calendar cal = null;
    private static SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static String filePath = null;

    static {
        String path = Thread.currentThread().getContextClassLoader().getResource("").getPath().substring(1);
        pro = Utils.loadProp(path + "pingAn.properties");
        if (Objects.isNull(pro)) {
            LoggerFactory.getLogger(HclcCmbPolyServiceImpl.class).error("配置文件初始化异常");
        }
        baseReqBody.put("MrchCode", pro.getProperty("MrchCode"));
        baseReqBody.put("MainAccount", pro.getProperty("AcctNo"));
        filePath = pro.getProperty("pingAnDownloadFilePath");

    }

    /**
     * @param interfaceName
     * @param params
     * @return
     */
    @Override
    public JSONObject invoke(IRequest iRequest, String interfaceName, JSONObject params) {
        JSONObject responseData = new JSONObject();
//        JSONObject requestBody = ApiUtils.getBaseReqBody();
        JSONObject requestBody = baseReqBody.clone();
        cal = Calendar.getInstance();
        String today = df.format(cal.getTime());
        long temp = Math.round(Math.random() * 899 + 100);// 产生100到999的随机数
        requestBody.put("CnsmrSeqNo", today + temp);
        requestBody.putAll(params);

        if ("bedl/DetailReportQueryNew".equalsIgnoreCase(interfaceName)) {
            requestBody.remove("MainAccount");
        }

        /*插入接口日志表*/
        HlsWsRequests hlsWsRequests = createRequestLog(pro.getProperty("baseUrl") + "/V1.0/" + interfaceName, requestBody.toJSONString(), 1L);
        logger.info("发送接口:" + interfaceName + "请求,请求参数: {}", requestBody.toString());
        try {
            HttpResult result = ApiUtils.invoke(interfaceName, requestBody);
            if (Objects.nonNull(result)) {
                // 通信成功
                logger.info("接口请求结果: {}", result.toString());
                if ("200".equals(result.getCode() + "")) {
                    JSONObject res = JSONObject.parseObject(result.getData());
                    switch (interfaceName) {
                        case "bedl/SubAcctMaintenance":
                            hlsWsRequests.setFunctionName("pingAn_SubAcctMaintenance");
                            break;
                        case "bedl/InquiryIntoTheCurrentDetailsOfMainSubaccountAccountTwo":
                            hlsWsRequests.setFunctionName("pingAn_recentDetailQuery");
                            break;
                        case "bedl/DetailReportQueryNew":
                            hlsWsRequests.setFunctionName("pingAn_DetailReportQueryNew");
                            break;
                        case "bedl/PrimaryAcctRelationshipQuery":
                            hlsWsRequests.setFunctionName("pingAn_QueryAccount");
                            break;
                    }
                    responseData.put("data", res);
                    // 具体业务是否请求成功判定,目前观察成功请求可能没有Code值
                    if (Objects.isNull(res.getString("Code")) || "000000".equals(res.getString("Code"))) {
                        if ("bedl/DetailReportQueryNew".equals(interfaceName)) {
                            dowloadDetailFile(res);
                        }
                        if ("bedl/SubAcctMaintenance".equals(interfaceName)) {
                            saveAccount(iRequest, res);
                        }
                        hlsWsRequests.setReturnStatus("S");
                        responseData.put(Constants.RESP_CODE, "0000");
                        responseData.put("respMsg", "请求成功");
                    } else {
                        //粗略的报错  如："Message":"业务处理失败（通讯成功）","Code":"E50000"
                        responseData.put(Constants.RESP_CODE, res.getString("Code"));
                        responseData.put(Constants.RESP_MSG, res.getString("Message"));
                        if (Objects.nonNull(res.getJSONArray("Errors"))) {
                            //详情报错  如："ErrorCode":"CE3887","ErrorMessage":":[CE3887]清分台账编码[30206688123456]记录已存在
                            responseData.put(Constants.RESP_CODE, res.getJSONArray("Errors").getJSONObject(0).getString("ErrorCode"));
                            responseData.put(Constants.RESP_MSG, res.getJSONArray("Errors").getJSONObject(0).getString("ErrorMessage"));
                        }
                    }
                } else {
                    //请求失败
                    hlsWsRequests.setReturnStatus("E");
                    responseData.put(Constants.RESP_CODE, result.getCode());
                    responseData.put(Constants.RESP_MSG, "请求失败，网络异常");
                }
                hlsWsRequests.setResponseJson(result.getData());
                hlsWsRequests.setResponsedDate(new Date());
            }
        } catch (OpenBankSdkException e) {
            hlsWsRequests.setReturnStatus("E");
            responseData.put(Constants.RESP_CODE, e.getCode());
            responseData.put(Constants.RESP_MSG, e.getMessage());
        }
        //更新日志
        hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        return responseData;
    }


    public JSONObject detailNotify(IRequest iRequest, JSONObject req) {
        JSONObject responseData = new JSONObject();
        logger.info("接收推送消息,推送参数: {}", req.toString());
        if (Objects.nonNull(req) && req.size() > 0) {
            try {
                // 存表
                //实际通知报文中会把数据放在ROOT这个key下
                JSONObject data = req.getJSONObject("ROOT");
                DefaultTransactionDefinition def = new DefaultTransactionDefinition();
                // 事务隔离级别：开启新事务
                def.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
                //对于每次请求都开启一个事物
                TransactionStatus transactionStatus = transactionManager.getTransaction(def);

                HlsEbankCcbTransaction hlsEbankCcbTransaction = saveTransaction(iRequest, data);
                //状态刷新
                transactionStatus.flush();
                //事务提交
                transactionManager.commit(transactionStatus);

                // 调用系统的接口服务，推送通知数据
                if ("C".equalsIgnoreCase(hlsEbankCcbTransaction.getTranType())) {
                    JSONObject ldo16 = new JSONObject();
                    ldo16.put("transaction_id", hlsEbankCcbTransaction.getTransactionId());
                    postNotify(ldo16.toString());
                }
            } catch (Exception e) {
                e.printStackTrace();
                logger.info("处理交易推送信息结果异常，异常原因：" + e.getMessage());
            }
//            responseData.put("TxnReturnCode ","000000");
//            responseData.put("TxnReturnMsg ","接收成功");
        }
//        else {
//            responseData.put("TxnReturnCode ","111111");
//            responseData.put("TxnReturnMsg ","接收失败");
//        }
        responseData.put("TxnReturnCode ", "000000");
        responseData.put("TxnReturnMsg ", "接收成功");
        return responseData;
    }


    private HlsWsRequests createRequestLog(String wsdlUrl, String requestClob, Long pkValue) {
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests.setRequestDate(new Date());
        hlsWsRequests.setRequestWsdlUrl(wsdlUrl);
        hlsWsRequests.setRequestJson(requestClob);
        hlsWsRequests.setStatusDate(new Date());
        hlsWsRequests.setParameterType("json");
        hlsWsRequests.setPkValue(pkValue);

        hlsWsRequestsMapper.insertSelective(hlsWsRequests);
        return hlsWsRequests;
    }

    private String postNotify(String params) {
        String sysName = "HCL_UPLOAD_FILE";
        String apiName = "writeOffLd016";
        try {
            //初始化接口信息
            HapInterfaceHeader headerAndLineDTO = headerService.getHeaderAndLine(sysName, apiName);
            if (headerAndLineDTO == null) {
                logger.info("headerAndLineDTO is null， apiName:{}, sysName:{}", apiName, sysName);
                return "N";
            }
            String url = headerAndLineDTO.getDomainUrl() + headerAndLineDTO.getIftUrl();
            Map<String, String> headInfo = new HashMap<String, String>();
            headInfo.put("Content-Type", "application/x-www-form-urlencoded");
            JSONObject requestData = new JSONObject();
            requestData.put("requestData", params);
            logger.info("发送接口:writeOffLd016请求,请求参数: {}", requestData.toString());
            //发送http请求
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, requestData, headInfo, SignHclcUtils.APPLICATION_FORM_URLENCODED);
            //解析返回结果
            JSONObject jsonResult = JSONObject.parseObject(stringResult);
            if ("S".equalsIgnoreCase(jsonResult.getString("respCode"))) {
                return "Y";
            } else {
                return "N";
            }
        } catch (Exception e) {
            e.printStackTrace();
            return "N";
        }
    }

    private HlsEbankCcbTransaction saveTransaction(IRequest iRequest, JSONObject data) {
        HlsEbankCcbTransaction ccbTransaction = new HlsEbankCcbTransaction();
        ccbTransaction.setStatus("SUCCESS");
        ccbTransaction.setNewDate(new Date());
        ccbTransaction.setSuccessDate(new Date());
        ccbTransaction.setAmount(data.getDouble("STT_VCH_AMT"));
        ccbTransaction.setCount(1L);
        ccbTransaction.setReturnCode("SUCCESS");
        ccbTransaction.setReturnMsg("交易成功");
        ccbTransaction.setBankType("PAB");
        ccbTransaction.setMerId(ApiUtils.AcctNo);
        ccbTransaction.setMerOrderNo(data.getString("STT_CONSUMER_SEQ_NO"));
        ccbTransaction.setVersion(data.getString("STT_AC_DATE"));
        ccbTransaction.setTranDate(data.getString("STT_TR_TIME"));
        ccbTransaction.setTranType(data.getString("STT_VCH_SIGN"));
        /*订单状态接收成功*/
        ccbTransaction.setOrderStatus("R");
        ccbTransaction.setCmbOrderId(data.getString("STT_JRN_NO"));
        ccbTransaction.setSttVchCardNo(data.getString("STT_VCH_CARD_NO"));
        ccbTransaction.setSttAcDate(data.getString("STT_AC_DATE"));
        ccbTransaction.setSttVchSeqNo(data.getString("STT_VCH_SEQ_NO"));
        ccbTransaction.setSttAmtRmb(data.getDouble("STT_AMT_RMB"));
        ccbTransaction.setSttVchBal(data.getDouble("STT_VCH_BAL"));
        ccbTransaction.setSttVchRcvAcNo(data.getString("STT_VCH_RCV_AC_NO"));
        ccbTransaction.setSttVchRcvAcName(data.getString("STT_VCH_RCV_AC_NAME"));
        ccbTransaction.setSttVchRcvBkName(data.getString("STT_VCH_RCV_BK_NAME"));
        ccbTransaction.setSttVchRcvBkNo(data.getString("STT_VCH_RCV_BK_NO"));
        ccbTransaction.setSttVchRemark(data.getString("STT_VCH_REMARK"));
        ccbTransaction.setReturnCode(data.getString("STT_VCH_MARKCODE"));
        ccbTransaction.setReturnMsg(data.getString("STT_VCH_PART"));
        ccbTransaction = hlsEbankCcbTransactionService.insertSelective(iRequest, ccbTransaction);

        //生成单据编号 日期+id
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        String dateString = formatter.format(new Date());
        ccbTransaction.setTransactionNumber(dateString + String.format("%08d", ccbTransaction.getTransactionId()));

        ccbTransaction = hlsEbankCcbTransactionService.updateByPrimaryKey(iRequest, ccbTransaction);

        return ccbTransaction;
    }

    //下载回单文件
    private void dowloadDetailFile(JSONObject data) {
        JSONArray arr = data.getJSONArray("list");
        List<OrderFile> orderFiles = new ArrayList<>();
        //转换成orderFile对象
        if (Objects.nonNull(arr)) {
            //手动转换，因为返回字段首字母均为大写，与实体类不对应。
            for (int i = 0; i < arr.size(); i++) {
                JSONObject item = arr.getJSONObject(i);
                OrderFile orderFile = new OrderFile();
                orderFile.setDocId(item.getString("DocId"));
                orderFile.setFileName(item.getString("FileName"));
                orderFile.setFileSize(item.getString("FileSize"));
                orderFiles.add(orderFile);
            }
            OrderFileRequest orderFileRequest = new OrderFileRequest();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            String dateString = formatter.format(new Date()) + "\\";
            orderFileRequest.setDownPath(filePath + dateString);
            File file = new File(orderFileRequest.getDownPath());
            if (!file.exists()) {
                file.mkdirs();
            }
            orderFileRequest.setOrderFiles(orderFiles);
            ApiUtils.getApiClient().orderFileDownload(orderFileRequest);
        }
    }

    /**
     * 近期明细查询
     *
     * @param interfaceName
     * @param params
     * @return
     */
    public JSONObject preInvoke(IRequest iRequest, String interfaceName, JSONObject params) {
        JSONObject responseData = new JSONObject();
        int pageNo = 0;
        String isEnd = "N";
        while ("N".equalsIgnoreCase(isEnd)) {
            params.put("PageNo", ++pageNo);
            JSONObject res = invoke(iRequest, interfaceName, params);
            // 对当前查询到的数据进行存表
            JSONObject data = res.getJSONObject("data");
            if (Objects.nonNull(data)) {
                isEnd = data.getString("IsEnd");
                JSONArray arr = data.getJSONArray("list");
                if (Objects.nonNull(arr)) {
                    batchSaveTransactionByC00602(iRequest, arr);
                }
            } else {
                responseData.put(Constants.RESP_CODE, "0001");
                responseData.put("respMsg", "查询出错");
                break;
            }
        }
        responseData.put(Constants.RESP_CODE, "0000");
        responseData.put("respMsg", "请求成功");
        return responseData;
    }

    @Override
    public JSONObject queryAccount(IRequest iRequest, String interfaceName, JSONObject params) {
        JSONObject responseData = new JSONObject();
        int pageNo = 0;
        String isEnd = "N";
        boolean mainFlag = true;
        while ("N".equalsIgnoreCase(isEnd)) {
            params.put("PageNo", ++pageNo);
            JSONObject res = invoke(iRequest, interfaceName, params);
            // 对当前查询到的数据进行存表
            JSONObject data = res.getJSONObject("data");
            if (Objects.nonNull(data)) {
                if (mainFlag) {
                    // 处理主账户,每次查询只处理一次
                    HlsEbankCcbAccount hlsEbankCcbAccount = new HlsEbankCcbAccount();
                    hlsEbankCcbAccount.setAccountNo(data.getString("ShadowAcctNo"));
                    Long recordId = hlsEbankCcbAccountMapper.queryByAccountNo(hlsEbankCcbAccount);
                    hlsEbankCcbAccount.setSubAccNum(data.getLong("SubAccNum"));
                    hlsEbankCcbAccount.setStt(data.getString("Stt"));
                    if (Objects.nonNull(recordId)) {
                        hlsEbankCcbAccount.setRecordId(recordId);
                        hlsEbankCcbAccountService.updateByPrimaryKeySelective(iRequest, hlsEbankCcbAccount);
                    } else {
                        hlsEbankCcbAccount.setMainFlag("Y");
                        hlsEbankCcbAccount.setMainAccount(data.getString("MainAccount"));
                        hlsEbankCcbAccount.setCorId(data.getString("CorId"));
                        hlsEbankCcbAccount.setAccName(data.getString("AccountName"));
                        hlsEbankCcbAccountService.insertSelective(iRequest, hlsEbankCcbAccount);
                    }
                    mainFlag = false;
                }

                isEnd = data.getString("IsEnd");
                batchSaveAccount(iRequest, data);
            } else {
                responseData.put(Constants.RESP_CODE, "1111");
                responseData.put("respMsg", "查询出错");
                break;
            }
        }
        responseData.put(Constants.RESP_CODE, "0000");
        responseData.put("respMsg", "请求成功");
        return responseData;
    }

    private void batchSaveTransactionByC00602(IRequest iRequest, JSONArray arr) {
        for (int i = 0; i < arr.size(); i++) {
            HlsEbankCcbTransaction ccbTransaction = new HlsEbankCcbTransaction();
            JSONObject data = arr.getJSONObject(i);
            if ("C".equalsIgnoreCase(data.getString("DCFlag"))) {
                ccbTransaction.setCmbOrderId(data.getString("JournalNo"));
                ccbTransaction.setTranType(data.getString("DCFlag"));
                int exist = hlsEbankCcbTransactionMapper.queryByCmbOrderId(ccbTransaction);
                if (exist == 0) {
                    ccbTransaction.setMerId(ApiUtils.AcctNo);
                    ccbTransaction.setSttVchCardNo(data.getString("SubAccount"));
                    ccbTransaction.setSttAcDate(data.getString("AccountDate"));
                    ccbTransaction.setAmount(data.getDouble("TranAmount"));
                    ccbTransaction.setSttAmtRmb(data.getDouble("TranAmount"));
                    ccbTransaction.setSttVchRcvAcNo(data.getString("OppAccountNo"));
                    ccbTransaction.setSttVchRcvAcName(data.getString("OppAccountName"));
                    ccbTransaction.setSttVchRcvBkName(data.getString("OppBankName"));
                    ccbTransaction.setSttVchRcvBkNo(data.getString("OppBankNo"));
                    ccbTransaction.setSttVchRemark(data.getString("Remark"));
                    ccbTransaction.setReturnCode(data.getString("SUCCESS"));
                    ccbTransaction.setReturnMsg(data.getString("交易成功"));
                    ccbTransaction.setStatus("SUCCESS");
                    ccbTransaction.setUserId(data.getString("MainAccount"));
                    ccbTransaction.setNewDate(new Date());
                    ccbTransaction.setSuccessDate(new Date());
                    ccbTransaction.setCount(1L);
                    ccbTransaction.setBankType("PAB");
                    ccbTransaction.setMerOrderNo(data.getString("BizFlowNo"));
                    ccbTransaction.setVersion(data.getString("AccountDate"));
                    ccbTransaction.setTranDate(data.getString("AccountDate"));
                    ccbTransaction.setTranTime(data.getString("TranTime"));
                    /*订单状态接收成功*/
                    ccbTransaction.setOrderStatus("R");
                    ccbTransaction.setSttVchSeqNo(data.getString("SeqNo"));
                    ccbTransaction.setSttVchBal(data.getDouble("Balance"));
                    ccbTransaction = hlsEbankCcbTransactionService.insertSelective(iRequest, ccbTransaction);

                    //生成单据编号 日期+id
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
                    String dateString = formatter.format(new Date());
                    ccbTransaction.setTransactionNumber(dateString + String.format("%08d", ccbTransaction.getTransactionId()));

                    hlsEbankCcbTransactionService.updateByPrimaryKey(iRequest, ccbTransaction);
                }
            }
        }
    }

    private void saveAccount(IRequest iRequest, JSONObject data) {
        HlsEbankCcbAccount hlsEbankCcbAccount = new HlsEbankCcbAccount();
        hlsEbankCcbAccount.setAccountNo(data.getString("SubAccountNo"));
        Long recordId = hlsEbankCcbAccountMapper.queryByAccountNo(hlsEbankCcbAccount);
        hlsEbankCcbAccount.setSubAccNum(data.getLong("SubAccNum"));
        hlsEbankCcbAccount.setStt(data.getString("SubStt"));
        hlsEbankCcbAccount.setAccBalance(data.getDouble("SubAccBalance"));
        if (Objects.nonNull(recordId)) {
            hlsEbankCcbAccount.setRecordId(recordId);
            hlsEbankCcbAccountService.updateByPrimaryKeySelective(iRequest, hlsEbankCcbAccount);
        } else {
            hlsEbankCcbAccount.setMainFlag("N");
            hlsEbankCcbAccount.setMainAccount(data.getString("MainAccount"));
            hlsEbankCcbAccount.setCorId(data.getString("CorId"));
            hlsEbankCcbAccount.setAccName(data.getString("SubAccName"));
            hlsEbankCcbAccountService.insertSelective(iRequest, hlsEbankCcbAccount);
        }
    }

    private void batchSaveAccount(IRequest iRequest, JSONObject data) {
        JSONArray list = data.getJSONArray("list");
        if (Objects.nonNull(list)) {
            for (int i = 0; i < list.size(); i++) {
                JSONObject item = list.getJSONObject(i);
                HlsEbankCcbAccount hlsEbankCcbAccount = new HlsEbankCcbAccount();
                hlsEbankCcbAccount.setAccountNo(item.getString("SubAccountNo"));
                Long recordId = hlsEbankCcbAccountMapper.queryByAccountNo(hlsEbankCcbAccount);
                hlsEbankCcbAccount.setSubAccNum(data.getLong("SubAccNum"));
                hlsEbankCcbAccount.setStt(item.getString("SubStt"));
                hlsEbankCcbAccount.setAccBalance(item.getDouble("SubAccBalance"));
                if (Objects.nonNull(recordId)) {
                    hlsEbankCcbAccount.setRecordId(recordId);
                    hlsEbankCcbAccountService.updateByPrimaryKeySelective(iRequest, hlsEbankCcbAccount);
                } else {
                    hlsEbankCcbAccount.setMainFlag("N");
                    hlsEbankCcbAccount.setMainAccount(data.getString("MainAccount"));
                    hlsEbankCcbAccount.setCorId(data.getString("CorId"));
                    hlsEbankCcbAccount.setAccName(item.getString("SubAccName"));
                    hlsEbankCcbAccountService.insertSelective(iRequest, hlsEbankCcbAccount);
                }
            }
        }
    }
}
