package com.hand.app.pingAn.controllers;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.pingAn.service.PingAnService;
import com.hand.app.pingAn.utils.ApiUtils;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.pingan.openbank.api.sdk.common.http.HttpResult;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Random;


@Controller
@RequestMapping(value = {"/r/api", "/"})
public class PingAnController extends BaseController {

    @Autowired
    private PingAnService pingAnService;

    @ApiModelProperty("子账户维护(BEDL_C002)")
    @RequestMapping("/bedl/SubAcctMaintenance")
    @ResponseBody
    public JSONObject bindSubAccount(HttpServletRequest request,@RequestBody(required = true) JSONObject reqParams){
        IRequest iRequest = createRequestContext(request);
        return pingAnService.invoke(iRequest,"bedl/SubAcctMaintenance",reqParams);
    }

    @ApiModelProperty("近期明细查询(BEDL_C00602)")
    @RequestMapping("/bedl/InquiryIntoTheCurrentDetailsOfMainSubaccountAccountTwo")
    @ResponseBody
    public JSONObject recentDetailQuery(HttpServletRequest request,@RequestBody(required = true) JSONObject reqParams){
        IRequest iRequest = createRequestContext(request);
        return pingAnService.preInvoke(iRequest,"bedl/InquiryIntoTheCurrentDetailsOfMainSubaccountAccountTwo",reqParams);
    }

    @ApiModelProperty("明细通知接口(BEDL_ZNA001)")
    @RequestMapping("/api/public/pingAn/notify")
    @ResponseBody
    public JSONObject DetailsNotify(HttpServletRequest request,@RequestBody(required = true) JSONObject data){
        IRequest iRequest = createRequestContext(request);
        return pingAnService.detailNotify(iRequest,data);
    }

    @ApiModelProperty("清分台账明细下载(BEDL_F0P101)")
    @RequestMapping("/bedl/DetailReportQueryNew")
    @ResponseBody
    public JSONObject downloadDetail(HttpServletRequest request,@RequestBody(required = true) JSONObject reqParams){
        IRequest iRequest = createRequestContext(request);
        reqParams.put("Account",ApiUtils.AcctNo);
        return pingAnService.invoke(iRequest,"bedl/DetailReportQueryNew", reqParams);
    }

    @ApiModelProperty("智能清分台账编码关系查询(BEDL_C001)")
    @RequestMapping("/bedl/PrimaryAcctRelationshipQuery")
    @ResponseBody
    public JSONObject queryAccount(HttpServletRequest request,@RequestBody(required = true) JSONObject reqParams){
        IRequest iRequest = createRequestContext(request);
        return pingAnService.queryAccount(iRequest,"bedl/PrimaryAcctRelationshipQuery", reqParams);
    }


}
