package com.hand.app.hms.service.impl;

import com.hand.hap.system.service.ISysConfigService;
import com.jcraft.jsch.*;
import com.hand.app.hms.service.IHmsFtpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;

/**
 * Created by Think on 2017/9/19.
 */
@Service
public class HmsFtpServiceImpl implements IHmsFtpService {

    @Autowired
    ISysConfigService ISysConfigService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Session sshSession;
    private ChannelSftp sftp;
    private String host = null;
    private String port = null;
    private String username = null;
    private String password = null;
    private String uploadDir = null;


    private void loadConfig() {
        host = ISysConfigService.getConfigValue("FTP.HOST");
        port = ISysConfigService.getConfigValue("FTP.PORT");
        username = ISysConfigService.getConfigValue("FTP.USERNAME");
        password = ISysConfigService.getConfigValue("FTP.PASSWORD");
        uploadDir = ISysConfigService.getConfigValue("FTP.UPLOADDIR");
    }

    /**
     * 连接sftp服务器
     *
     * @return
     */
    @Override
    public Boolean connect() {
        this.loadConfig();
        try {
            JSch jsch = new JSch();
            jsch.getSession(username, host, Integer.parseInt(port));
            sshSession = jsch.getSession(username, host, Integer.parseInt(port));
            sshSession.setPassword(password);
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            sshSession.setConfig(sshConfig);
            sshSession.connect();
            Channel channel = sshSession.openChannel("sftp");
            channel.connect();
            sftp = (ChannelSftp) channel;
            logger.info("Connected to " + host + ".");
            return true;
        } catch (Exception e) {
            logger.error("sftp connect fail");
            disconnect();
        }
        return false;
    }


    /**
     * 关闭连接
     */
    @Override
    public void disconnect() {
        if (sftp != null) {
            sftp.exit();
        }
        if (sshSession != null) {
            sshSession.disconnect();
        }
        logger.info("sshSession disconnect");
    }



    @Override
    public String upload(String directory, InputStream in, String fileName) {
        this.connect();
        if (fileName.isEmpty()) {
            fileName = UUID.randomUUID().toString().replace("-", "").toUpperCase();
        }
        String dir = directory;
        try {
            sftp.cd(dir);
        } catch (Exception e) {
            try {
                sftp.mkdir(dir);
                sftp.cd(dir);
            } catch (SftpException e1) {
                e1.printStackTrace();
            }
        }
        try {
            sftp.put(in, fileName);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            this.disconnect();
        }

        return dir + fileName;
    }

    ;

    /**
     * 下载文件
     */
    @Override
    public InputStream download(String downloadFile) {
        try {
            InputStream in = sftp.get(downloadFile);
            return in;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }



    /**
     * 删除文件
     */
    @Override
    public void delete(String directory, String deleteFile) {
        try {
            sftp.cd(directory);
            sftp.rm(deleteFile);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }



    /**
     * 创建指定文件夹
     *
     * @param dirName dirName
     */
    @Override
    public void mkDir(String basePath, String dirName) {
        String[] dirs = dirName.split("/");
        try {
            sftp.cd(basePath);
            for (int i = 0; i < dirs.length; i++) {
                boolean dirExists = openDir(dirs[i]);
                if (!dirExists) {
                    sftp.mkdir(dirs[i]);
                    sftp.cd(dirs[i]);
                }

            }
        } catch (SftpException e) {
            logger.error("mkDir Exception : " + e);
        }
    }

    ;

    /**
     * 打开指定目录
     *
     * @param directory directory
     * @return 是否打开目录
     */
    @Override
    public boolean openDir(String directory) {
        try {
            sftp.cd(directory);
            return true;
        } catch (SftpException e) {
            logger.error("openDir Exception : " + e);
            return false;
        }
    }



    @Override
    public void rename(String oldPath, String newPath) {
        try {
            sftp.rename(oldPath, newPath);
        } catch (Exception e) {
            logger.error("openDir Exception：" + e);
        }
    }

}
