/**
 * Copyright (C), 2018-2021
 * FileName: HclcChinaPayController
 * Author:   lsy
 * Date:     2021/12/8 14:40
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * lishuangyi        修改时间           版本号              描述
 */
package com.hand.app.cmb.controllers;

import com.alibaba.fastjson.JSONObject;
import com.chinapay.service.IHclcChinaPayService;
import com.hand.app.cmb.service.HclcCmbPolyService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/*
 * 〈〉
 *
 * @author 27214
 * @create 2021/12/8
 * @since 1.0.0
 */
@Controller
@RequestMapping(value = {"/r/api", "/"})
public class HclcCmbPolyController extends BaseController {

    @Autowired
    HclcCmbPolyService hclcCmbPolyService;

    /**
     * 获取二维码
     *
     * @param request
     * @param params  还款信息
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/cmb/poly/get/qrcode")
    public JSONObject sendSignMessage(HttpServletRequest request,
                                      @RequestBody(required = true) JSONObject params) {
        JSONObject jsonResult = new JSONObject();
        IRequest iRequest = createRequestContext(request);
        jsonResult = hclcCmbPolyService.getQrcode(iRequest, params);
        return jsonResult;
    }

    /**
     * 主动请求订单状态结果
     * @param request
     * @param params
     * @return
     */
    @ResponseBody
    @RequestMapping("/cmb/poly/query/order/status")
    public JSONObject queryOrderStatus(HttpServletRequest request,
                                      @RequestBody(required = true) JSONObject params) {
        JSONObject jsonResult = new JSONObject();
        IRequest iRequest = createRequestContext(request);
        jsonResult = hclcCmbPolyService.queryOrderStatus(iRequest, params);
        return jsonResult;
    }

    //订单关闭 4.7.1
    @ResponseBody
    @RequestMapping("/cmb/poly/close/order")
    public JSONObject closeOrder(HttpServletRequest request,
                                       @RequestBody(required = true) JSONObject params) {
        JSONObject jsonResult = new JSONObject();
        IRequest iRequest = createRequestContext(request);
        jsonResult = hclcCmbPolyService.closeOrder(iRequest, params);
        return jsonResult;
    }


}