package com.hand.app.appManger.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import com.hand.app.appManger.dto.AppTime;
import com.hand.app.appManger.mapper.AppTimeMapper;
import com.hand.app.appManger.service.IAppTimeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;

/**
 * Created by 晓兵 on 2018/4/19.
 */
@Service
public class AppTimeServiceImpl extends BaseServiceImpl<AppTime> implements IAppTimeService {
    @Autowired
   private AppTimeMapper AppTimeMapper;
    private int betweenDay;
    private int totleDay;
    @Override
    public ResponseData getTime(IRequest request, Integer timeId, Integer userId) {
        List<AppTime> appTime = AppTimeMapper.getTime(timeId,userId);
        Date date = new Date();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate currentTime = date.toInstant().atZone(zoneId).toLocalDate();

        if(appTime.size()>0) {
            for (int i = 0; i < appTime.size(); i++) {
                AppTime apptime = appTime.get(i);
                LocalDate timeStart = apptime.getTimeStart().toInstant().atZone(zoneId).toLocalDate();
                if (apptime.getTimeType().equals("001")) {    //倒数日
                    LocalDate timeEnd = apptime.getTimeEnd().toInstant().atZone(zoneId).toLocalDate();
                    totleDay = (int)ChronoUnit.DAYS.between(timeStart, timeEnd);
                    betweenDay = (int)ChronoUnit.DAYS.between(currentTime, timeEnd);
                    if(betweenDay<=0){
                        betweenDay = 0;
                    }
                    apptime.setTotleDate(totleDay);
                    apptime.setPassDay(totleDay - betweenDay);
                } else {                          //累积日
                    betweenDay = (int)ChronoUnit.DAYS.between(timeStart, currentTime);
                }
                apptime.setBetweenDay(betweenDay);

            }
        }

        return new ResponseData(appTime);
    }
}

