package com.hand.app.appManger.service.impl;

import com.hand.app.appManger.bean.RoleModule;
import com.hand.app.appManger.mapper.AppRoleFunctionMapper;
import com.hand.app.appManger.mapper.RoleModuleMapper;
import com.hand.app.appManger.service.IAppFunctionService;
import com.hand.app.appManger.dto.AppFunction;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by Think-PC on 2018/3/14.
 */
@Service
public class AppFunctionServiceImpl extends BaseServiceImpl<AppFunction> implements IAppFunctionService {
    @Autowired
    private RoleModuleMapper roleModuleMapper;
    @Autowired
    private AppRoleFunctionMapper appRoleFunctionMapper;

    @Override
    public ResponseData getModuleFunction(IRequest request, String roleCode, String appCode) {
        List<RoleModule> roleModule = roleModuleMapper.getRoleModule(roleCode,appCode);
        if (roleModule.size() > 0) {
            for (int i = 0; i < roleModule.size(); i++) {
                RoleModule role = roleModule.get(i);
                role.setFunctions(appRoleFunctionMapper.getRoleFunction(role.getModuleId().toString(), roleCode, appCode));
            }
        }
        return new ResponseData(roleModule);
    }
}
