/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.utils;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatPicUtils {
    private static Logger logger = LoggerFactory.getLogger(WechatPicUtils.class);

    public static boolean png2Jpeg(File png, String jpegPath, Double scale) {
        return WechatPicUtils.picScale(png, jpegPath, scale, "jpg");
    }

    public static boolean picScale(File src, String savePath, Double scale, String format) {
        return WechatPicUtils.picScale(src, new File(savePath), scale, format);
    }

    public static boolean picScale(File src, File dist, Double scale, String format) {
        if (logger.isDebugEnabled()) {
            logger.debug("src file:{}, dist path: {}", (Object)src, (Object)dist);
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(src);
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            if (scale != null && scale > 0.0) {
                width = (int)((double)width * scale);
                height = (int)((double)height * scale);
            }
            BufferedImage newBufferedImage = new BufferedImage(width, height, 1);
            newBufferedImage.createGraphics().drawImage(bufferedImage.getScaledInstance(width, height, 4), 0, 0, Color.WHITE, null);
            if (format == null || format.trim().length() < 1) {
                String name = dist.getName();
                format = name.substring(name.lastIndexOf(".") + 1);
            }
            ImageIO.write((RenderedImage)newBufferedImage, format, dist);
        }
        catch (IOException e) {
            logger.error("transfer pic failed: {}", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean picScale(File src, String savePath, int width, int height, String format) {
        return WechatPicUtils.picScale(src, new File(savePath), width, height, format);
    }

    public static boolean picScale(File src, File dist, int width, int height, String format) {
        if (logger.isDebugEnabled()) {
            logger.debug("src file:{}, dist file: {}, width: {}, height: {}", new Object[]{src, dist, width, height});
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(src);
            BufferedImage newBufferedImage = new BufferedImage(width, height, 1);
            newBufferedImage.createGraphics().drawImage(bufferedImage.getScaledInstance(width, height, 4), 0, 0, Color.WHITE, null);
            if (format == null || format.trim().length() < 1) {
                String name = dist.getName();
                format = name.substring(name.lastIndexOf(".") + 1);
            }
            ImageIO.write((RenderedImage)newBufferedImage, format, dist);
        }
        catch (IOException e) {
            logger.error("transfer pic failed: {}", (Throwable)e);
            return false;
        }
        return true;
    }
}

