/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatHttpUtils {
    public static final int CODE_REQUEST_FAILED = -12;
    private static Logger logger = LoggerFactory.getLogger(WechatHttpUtils.class);

    public static JSONObject postForJson(String url, Map<String, Object> params) {
        JSONObject jsonObject = new JSONObject();
        CloseableHttpResponse execute = null;
        try {
            HttpPost post = new HttpPost(url);
            StringEntity param = new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)param);
            CloseableHttpClient client = HttpClients.createDefault();
            execute = client.execute((HttpUriRequest)post);
        }
        catch (IOException e) {
            jsonObject.put("errcode", (Object)-12);
            jsonObject.put("errmsg", (Object)e.getMessage());
            logger.error("client execute failed: ", (Throwable)e);
        }
        if (execute != null) {
            HttpEntity entity = execute.getEntity();
            try {
                String s = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                jsonObject = JSON.parseObject((String)s);
            }
            catch (IOException e) {
                logger.error("entity parse failed: ", (Throwable)e);
            }
        }
        return jsonObject;
    }

    public static JSONObject getForJson(String url) {
        JSONObject jsonObject = new JSONObject();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).setRedirectsEnabled(true).build();
        CloseableHttpResponse execute = null;
        try {
            HttpGet get = new HttpGet(url);
            get.setConfig(requestConfig);
            CloseableHttpClient client = HttpClients.createDefault();
            execute = client.execute((HttpUriRequest)get);
        }
        catch (IOException e) {
            jsonObject.put("errcode", (Object)-12);
            jsonObject.put("errmsg", (Object)e.getMessage());
            logger.error("client execute failed: ", (Throwable)e);
        }
        if (execute != null) {
            HttpEntity entity = execute.getEntity();
            try {
                String s = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                jsonObject = JSON.parseObject((String)s);
            }
            catch (IOException e) {
                logger.error("entity parse failed: ", (Throwable)e);
            }
        }
        return jsonObject;
    }
}

