/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Formatter;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.api.impl.WxCpServiceImpl;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.config.WxCpInMemoryConfigStorage;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.WxMpInMemoryConfigStorage;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class WeChatUtils {
    private static final Integer standardSize = 0x200000;
    private static Logger log = LoggerFactory.getLogger(WeChatUtils.class);

    public static WxCpService initWxCpService(String corpId, String secret, Integer agentId, String proxyHost, Integer proxyPort) {
        WxCpInMemoryConfigStorage config = new WxCpInMemoryConfigStorage();
        config.setCorpId(corpId);
        config.setCorpSecret(secret);
        if (proxyHost != null && proxyPort != null) {
            config.setHttpProxyHost(proxyHost);
            config.setHttpProxyPort(proxyPort.intValue());
        }
        if (agentId != null) {
            config.setAgentId(agentId);
        }
        WxCpServiceImpl wxCpService = new WxCpServiceImpl();
        wxCpService.setWxCpConfigStorage((WxCpConfigStorage)config);
        return wxCpService;
    }

    public static WxMpService initWxMpService(String appId, String secret, String proxyHost, Integer proxyPort) {
        WxMpInMemoryConfigStorage config = new WxMpInMemoryConfigStorage();
        config.setAppId(appId);
        config.setSecret(secret);
        if (proxyHost != null && proxyPort != null) {
            config.setHttpProxyHost(proxyHost);
            config.setHttpProxyPort(proxyPort.intValue());
        }
        WxMpServiceImpl wxMpService = new WxMpServiceImpl();
        wxMpService.setWxMpConfigStorage((WxMpConfigStorage)config);
        return wxMpService;
    }

    public static boolean compressImage(MultipartFile image, File dest) {
        if (image.getSize() > (long)standardSize.intValue()) {
            try {
                Thumbnails.of((InputStream[])new InputStream[]{image.getInputStream()}).scale((double)((float)standardSize.intValue() / (float)image.getSize())).toFile(dest);
            }
            catch (IOException e) {
                log.error("compress image failed:", (Throwable)e);
                return false;
            }
        }
        try {
            image.transferTo(dest);
        }
        catch (IOException e) {
            log.error("save image failed:", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String formatIds(String ids, Boolean isCorp) {
        if (StringUtils.isNotEmpty((String)(ids = StringUtils.trim((String)ids)))) {
            if (StringUtils.endsWith((String)ids, (String)",")) {
                ids = StringUtils.removeEnd((String)ids, (String)",");
            }
            if (isCorp.booleanValue()) {
                StringUtils.replace((String)ids, (String)",", (String)"|");
            }
        }
        return ids;
    }

    public static String[] formatIds(String ids) {
        if (StringUtils.isNotEmpty((String)(ids = StringUtils.trim((String)ids)))) {
            if (StringUtils.endsWith((String)ids, (String)",")) {
                ids = StringUtils.removeEnd((String)ids, (String)",");
            }
            return StringUtils.split((String)ids, (String)",");
        }
        return null;
    }

    public static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }
}

