/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatTag;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatTagMapper;
import hls.support.core.wechat.service.IWechatTagService;
import hls.support.core.wechat.utils.WeChatUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpTag;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class WechatTagServiceImpl
extends BaseServiceImpl<WechatTag>
implements IWechatTagService {
    private static Logger logger = LoggerFactory.getLogger(WechatTagServiceImpl.class);
    @Autowired
    private WechatTagMapper wechatTagMapper;
    @Autowired
    private WechatAccountMapper wechatAccountMapper;
    @Value(value="#{configProperties['http.proxy.port']}")
    private Integer proxyPort;
    @Value(value="#{configProperties['http.proxy.host']}")
    private String proxyHost;

    @Override
    public List<WechatTag> queryTag(IRequest requestContext, WechatTag dto, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        return this.wechatTagMapper.queryTag(dto);
    }

    @Override
    public ResponseData refreshTag(IRequest reusetContext, Long accountId) {
        WechatAccount account;
        ResponseData responseData = new ResponseData(false);
        if (accountId == null) {
            responseData.setMessage("invalid params");
            logger.error("accountId is null when refresh tag datas!");
        }
        if ((account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(accountId)) == null) {
            responseData.setMessage("could not found target wechat account");
            logger.error("target wechat account can not be found!");
        }
        WxCpService wxCpService = WeChatUtils.initWxCpService(account.getAppId(), account.getSecret(), null, this.proxyHost, this.proxyPort);
        try {
            List wxCpTags = wxCpService.getTagService().listAll();
            WechatTag t = new WechatTag();
            t.setAccountId(accountId);
            List<WechatTag> wechatTags = this.wechatTagMapper.queryTag(t);
            ArrayList<String> tagIds = new ArrayList<String>();
            for (WxCpTag wxCpTag : wxCpTags) {
                tagIds.add(wxCpTag.getId());
            }
            for (WechatTag wechatTag : wechatTags) {
                if (tagIds.indexOf(wechatTag.getTagId()) >= 0) continue;
                ((IWechatTagService)this.self()).deleteByPrimaryKey(wechatTag);
            }
            for (WxCpTag wxCpTag : wxCpTags) {
                t.setTagId(wxCpTag.getId());
                t.setTagName(wxCpTag.getName());
                t.setAccountId(accountId);
                List<WechatTag> tags = this.wechatTagMapper.queryTag(t);
                if (CollectionUtils.isNotEmpty(tags)) {
                    t.setId(tags.get(0).getId());
                    this.wechatTagMapper.updateByPrimaryKey(t);
                    continue;
                }
                this.wechatTagMapper.insertSelective(t);
            }
            responseData.setSuccess(true);
        }
        catch (WxErrorException e) {
            logger.error("refresh tags data failed:", (Throwable)e);
            responseData.setMessage("refresh tags data failed.");
        }
        return responseData;
    }

    @Override
    public Boolean batchUpdateTag(IRequest requestContext, List<WechatTag> tags) {
        block10: for (WechatTag tag : tags) {
            switch (tag.get__status()) {
                case "add": {
                    if (((IWechatTagService)this.self()).addTag(requestContext, tag).booleanValue()) continue block10;
                    return false;
                }
                case "update": {
                    if (((IWechatTagService)this.self()).updateTag(requestContext, tag).booleanValue()) continue block10;
                    return false;
                }
                case "delete": {
                    if (((IWechatTagService)this.self()).deleteTag(requestContext, tag).booleanValue()) continue block10;
                    return false;
                }
            }
            logger.warn("__status is not set properly when batch update wechat tag.");
        }
        return true;
    }

    @Override
    public boolean addTagUsers(IRequest iRequest, WechatTag tag) {
        String userIds = tag.getUserIds();
        if (StringUtils.isEmpty((CharSequence)userIds)) {
            return true;
        }
        if (tag.getAccountId() == null) {
            logger.error("accountId is null when add a wechat tag!");
            return false;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(tag.getAccountId());
        if (account == null) {
            logger.error("target wechat account can not be found!");
            return false;
        }
        WxCpService wxCpService = WeChatUtils.initWxCpService(account.getAppId(), account.getSecret(), null, this.proxyHost, this.proxyPort);
        try {
            List<String> userIdList = Arrays.asList(userIds.split(","));
            if (userIdList.get(userIdList.size() - 1).equals("")) {
                userIdList.remove(userIdList.size() - 1);
            }
            wxCpService.getTagService().addUsers2Tag(tag.getTagId(), userIdList, null);
        }
        catch (WxErrorException e) {
            logger.error("wxCpService add users to tag failed:", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean removeTagUsers(IRequest requestContext, WechatTag tag) {
        String userIds = tag.getUserIds();
        if (StringUtils.isEmpty((CharSequence)userIds)) {
            return true;
        }
        if (tag.getAccountId() == null) {
            logger.error("accountId is null when add a wechat tag!");
            return false;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(tag.getAccountId());
        if (account == null) {
            logger.error("target wechat account can not be found!");
            return false;
        }
        WxCpService wxCpService = WeChatUtils.initWxCpService(account.getAppId(), account.getSecret(), null, this.proxyHost, this.proxyPort);
        try {
            List<String> userIdList = Arrays.asList(userIds.split(","));
            if (userIdList.get(userIdList.size() - 1).equals("")) {
                userIdList.remove(userIdList.size() - 1);
            }
            wxCpService.getTagService().removeUsersFromTag(tag.getTagId(), userIdList);
        }
        catch (WxErrorException e) {
            logger.error("wxCpService delete delete users from tag failed:", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Boolean deleteTag(IRequest iRequest, WechatTag dto) {
        if (dto.getAccountId() == null) {
            logger.error("accountId is null when add a wechat tag!");
            return false;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(dto.getAccountId());
        if (account == null) {
            logger.error("target wechat account can not be found!");
            return false;
        }
        WxCpService wxCpService = WeChatUtils.initWxCpService(account.getAppId(), account.getSecret(), null, this.proxyHost, this.proxyPort);
        try {
            wxCpService.getTagService().delete(dto.getTagId());
        }
        catch (WxErrorException e) {
            logger.error("wxCpService delete a tag failed:", (Throwable)e);
            return false;
        }
        this.wechatTagMapper.deleteByPrimaryKey(dto);
        return true;
    }

    @Override
    public Boolean updateTag(IRequest iRequest, WechatTag dto) {
        if (dto.getAccountId() == null) {
            logger.error("accountId is null when add a wechat tag!");
            return false;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(dto.getAccountId());
        if (account == null) {
            logger.error("target wechat account can not be found!");
            return false;
        }
        WxCpService wxCpService = WeChatUtils.initWxCpService(account.getAppId(), account.getSecret(), null, this.proxyHost, this.proxyPort);
        try {
            wxCpService.getTagService().update(dto.getTagId(), dto.getTagName());
        }
        catch (WxErrorException e) {
            logger.error("wxCpService update a tag failed:", (Throwable)e);
            return false;
        }
        this.wechatTagMapper.updateByPrimaryKeySelective(dto);
        return true;
    }

    @Override
    public Boolean addTag(IRequest iRequest, WechatTag dto) {
        String tagId;
        if (dto.getAccountId() == null) {
            logger.error("accountId is null when add a wechat tag!");
            return false;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(dto.getAccountId());
        if (account == null) {
            logger.error("target wechat account can not be found!");
            return false;
        }
        WxCpService wxCpService = WeChatUtils.initWxCpService(account.getAppId(), account.getSecret(), null, this.proxyHost, this.proxyPort);
        try {
            tagId = wxCpService.getTagService().create(dto.getTagName());
        }
        catch (WxErrorException e) {
            logger.error("wxcpService create tag failed:", (Throwable)e);
            return false;
        }
        dto.setTagId(tagId);
        this.wechatTagMapper.insertSelective(dto);
        return true;
    }
}

