/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.MPNewsThumbPicture;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.formbean.Article;
import hls.support.core.wechat.formbean.TemplateData;
import hls.support.core.wechat.formbean.TemplateMessage;
import hls.support.core.wechat.formbean.WxMessageBean;
import hls.support.core.wechat.mapper.MPNewsThumbPictureMapper;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.service.IWechatMessageService;
import hls.support.core.wechat.utils.WeChatUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpMessage;
import me.chanjar.weixin.cp.bean.article.NewArticle;
import me.chanjar.weixin.cp.bean.messagebuilder.TextBuilder;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.WxMpMassNews;
import me.chanjar.weixin.mp.bean.WxMpMassOpenIdsMessage;
import me.chanjar.weixin.mp.bean.WxMpMassTagMessage;
import me.chanjar.weixin.mp.bean.kefu.WxMpKefuMessage;
import me.chanjar.weixin.mp.bean.material.WxMpMaterial;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialUploadResult;
import me.chanjar.weixin.mp.bean.result.WxMpMassUploadResult;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateIndustry;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import me.chanjar.weixin.mp.builder.kefu.ImageBuilder;
import me.chanjar.weixin.mp.builder.kefu.NewsBuilder;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(rollbackFor={Exception.class})
public class WechatMessageServiceImpl
implements IWechatMessageService {
    private static Logger logger = LoggerFactory.getLogger(WechatMessageServiceImpl.class);
    private Integer INVALID_DATA = -1;
    private Integer CORP = 1;
    private Integer SUBS = 2;
    private Integer SERV = 3;
    @Autowired
    private WechatEnterpriseAppMapper wechatEnterpriseAppMapper;
    @Autowired
    private WechatAccountMapper wechatAccountMapper;
    @Autowired
    private MPNewsThumbPictureMapper mpNewsThumbPictureMapper;
    @Value(value="#{configProperties['file.upload.dir']}")
    private String uploadDir;
    @Value(value="#{configProperties['ftp.upload.dir']}")
    private String ftpUploadDir;
    @Value(value="#{configProperties['http.proxy.port']}")
    private Integer proxyPort;
    @Value(value="#{configProperties['http.proxy.host']}")
    private String proxyHost;

    @Override
    public ResponseData getAllTemplate(IRequest requestCtx, TemplateMessage templateMessage) {
        ResponseData responseData = new ResponseData(false);
        Integer type = this.judgeType(templateMessage.getAccountId(), templateMessage.getWechatAppId(), templateMessage.getWxCode());
        if (!type.equals(this.SERV)) {
            responseData.setMessage("invalid account type");
            return responseData;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(templateMessage.getAccountId());
        if (account == null) {
            responseData.setMessage("target account could not found.");
            return responseData;
        }
        WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
        try {
            List templates = wxMpService.getTemplateMsgService().getAllPrivateTemplate();
            responseData.setRows(templates);
            responseData.setSuccess(true);
            return responseData;
        }
        catch (WxErrorException e) {
            logger.error("get template list failed.", (Throwable)e);
            responseData.setMessage("get template list failed," + e.getMessage());
            return responseData;
        }
    }

    @Override
    public ResponseData delTemplate(IRequest requestCtx, TemplateMessage templateMessage) {
        ResponseData responseData = new ResponseData(false);
        Integer type = this.judgeType(templateMessage.getAccountId(), templateMessage.getWechatAppId(), templateMessage.getWxCode());
        if (!type.equals(this.SERV)) {
            responseData.setMessage("invalid account type");
            return responseData;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(templateMessage.getAccountId());
        if (account == null) {
            responseData.setMessage("target account could not found.");
            return responseData;
        }
        if (StringUtils.isEmpty((String)templateMessage.getTemplateId())) {
            responseData.setMessage("templateId is empty");
            return responseData;
        }
        WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
        try {
            wxMpService.getTemplateMsgService().delPrivateTemplate(templateMessage.getTemplateId());
        }
        catch (WxErrorException e) {
            logger.error("delete template failed. ", (Throwable)e);
            responseData.setMessage("delete template failed." + e.getMessage());
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    @Override
    public ResponseData getIndustry(IRequest requestCtx, TemplateMessage templateMessage) {
        ResponseData responseData = new ResponseData(false);
        Integer type = this.judgeType(templateMessage.getAccountId(), templateMessage.getWechatAppId(), templateMessage.getWxCode());
        if (!type.equals(this.SERV)) {
            responseData.setMessage("invalid account type");
            return responseData;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(templateMessage.getAccountId());
        if (account == null) {
            responseData.setMessage("target account could not found.");
            return responseData;
        }
        WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
        try {
            WxMpTemplateIndustry industry = wxMpService.getTemplateMsgService().getIndustry();
            ArrayList<WxMpTemplateIndustry> objects = new ArrayList<WxMpTemplateIndustry>();
            objects.add(industry);
            responseData.setRows(objects);
            responseData.setSuccess(true);
            return responseData;
        }
        catch (WxErrorException e) {
            logger.error("get industry failed,", (Throwable)e);
            responseData.setMessage("get industry failed," + e.getMessage());
            return responseData;
        }
    }

    @Override
    public ResponseData setIndustry(IRequest requestCtx, TemplateMessage templateMessage) {
        ResponseData responseData = new ResponseData(false);
        Integer type = this.judgeType(templateMessage.getAccountId(), templateMessage.getWechatAppId(), templateMessage.getWxCode());
        if (templateMessage.getPrimaryIndustry() == null) {
            responseData.setMessage("industry is empty.");
        }
        if (!type.equals(this.SERV)) {
            responseData.setMessage("invalid account type");
            return responseData;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(templateMessage.getAccountId());
        if (account == null) {
            responseData.setMessage("target account could not found.");
            return responseData;
        }
        WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
        WxMpTemplateIndustry wxMpTemplateIndustry = new WxMpTemplateIndustry();
        WxMpTemplateIndustry.Industry primaryIndustry = new WxMpTemplateIndustry.Industry();
        WxMpTemplateIndustry.Industry secondIndustry = new WxMpTemplateIndustry.Industry();
        BeanUtils.copyProperties((Object)templateMessage.getPrimaryIndustry(), (Object)primaryIndustry);
        BeanUtils.copyProperties((Object)templateMessage.getSecondIndustry(), (Object)secondIndustry);
        wxMpTemplateIndustry.setPrimaryIndustry(primaryIndustry);
        wxMpTemplateIndustry.setSecondIndustry(secondIndustry);
        try {
            wxMpService.getTemplateMsgService().setIndustry(wxMpTemplateIndustry);
        }
        catch (WxErrorException e) {
            logger.error("set industry failed.", (Throwable)e);
            responseData.setMessage("set industry failed: " + e.getMessage());
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    @Override
    public ResponseData addTemplate(IRequest requestCtx, TemplateMessage templateMessage) {
        ResponseData responseData = new ResponseData(false);
        Integer type = this.judgeType(templateMessage.getAccountId(), templateMessage.getWechatAppId(), templateMessage.getWxCode());
        if (StringUtils.isEmpty((String)templateMessage.getShortTemplateId())) {
            responseData.setMessage("shortTemplateId is empty.");
        }
        if (!type.equals(this.SERV)) {
            responseData.setMessage("invalid account type");
            return responseData;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(templateMessage.getAccountId());
        if (account == null) {
            responseData.setMessage("target account could not found.");
            return responseData;
        }
        WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
        try {
            String string = wxMpService.getTemplateMsgService().addTemplate(templateMessage.getShortTemplateId());
        }
        catch (WxErrorException e) {
            logger.error("add template failed.", (Throwable)e);
            responseData.setMessage("add template failed: " + e.getMessage());
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    @Override
    public ResponseData sendTemplateMsg(IRequest requestCtx, TemplateMessage templateMessage) {
        ResponseData responseData = new ResponseData(false);
        Integer type = this.judgeType(templateMessage.getAccountId(), templateMessage.getWechatAppId(), templateMessage.getWxCode());
        if (StringUtils.isEmpty((String)templateMessage.getShortTemplateId())) {
            responseData.setMessage("shortTemplateId is empty.");
        }
        if (!type.equals(this.SERV)) {
            responseData.setMessage("invalid account type");
            return responseData;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(templateMessage.getAccountId());
        if (account == null) {
            responseData.setMessage("target account could not found.");
            return responseData;
        }
        if (CollectionUtils.isEmpty(templateMessage.getTemplateDatas()) || StringUtils.isEmpty((String)templateMessage.getToUser()) || StringUtils.isEmpty((String)templateMessage.getShortTemplateId())) {
            responseData.setMessage("message data is empty or templateId is empty or target user is empty");
            return responseData;
        }
        ArrayList<WxMpTemplateData> dataList = new ArrayList<WxMpTemplateData>();
        for (TemplateData data : templateMessage.getTemplateDatas()) {
            WxMpTemplateData templateData = new WxMpTemplateData();
            BeanUtils.copyProperties((Object)data, (Object)templateData);
            dataList.add(templateData);
        }
        WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
        WxMpTemplateMessage message = WxMpTemplateMessage.builder().templateId(templateMessage.getTemplateId()).data(dataList).url(templateMessage.getUrl()).toUser(templateMessage.getToUser()).build();
        try {
            wxMpService.getTemplateMsgService().sendTemplateMsg(message);
        }
        catch (WxErrorException e) {
            logger.error("send template message error.", (Throwable)e);
            responseData.setMessage("send template message error," + e.getMessage());
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    @Override
    public ResponseData sendKefuMessage(IRequest requestCtx, WxMessageBean messageBean) {
        switch (messageBean.getMessageType()) {
            case "text": {
                return this.sendKefuText(messageBean);
            }
            case "image": {
                return this.sendKefuImage(messageBean);
            }
            case "mpnews": {
                return this.sendKefuMpNews(messageBean);
            }
            case "video": {
                return new ResponseData();
            }
            case "voice": {
                return new ResponseData();
            }
        }
        logger.error("Invalid message type.");
        ResponseData responseData = new ResponseData(false);
        responseData.setMessage("Invalid message type");
        return responseData;
    }

    private ResponseData sendKefuMpNews(WxMessageBean messageBean) {
        ResponseData responseData = new ResponseData(false);
        Integer type = this.judgeType(messageBean.getAccountId(), messageBean.getAppId(), messageBean.getWxCode());
        if (type.equals(this.INVALID_DATA) || StringUtils.isEmpty((String)messageBean.getOpenId()) && StringUtils.isEmpty((String)messageBean.getUserIds())) {
            responseData.setMessage("parameter data is invalid");
            return responseData;
        }
        if (type.equals(this.CORP)) {
            return this.sendCpMPNews(messageBean);
        }
        WechatEnterpriseApp app = this.getWechatEnterpriseApp(messageBean);
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(app.getAccountId());
        WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
        ArrayList<WxMpKefuMessage.WxArticle> articles = new ArrayList<WxMpKefuMessage.WxArticle>();
        for (Article article : messageBean.getArticles()) {
            WxMpKefuMessage.WxArticle wxArticle = new WxMpKefuMessage.WxArticle();
            wxArticle.setTitle(article.getTitle());
            wxArticle.setUrl(article.getUrl());
            wxArticle.setPicUrl(article.getPicUrl());
            wxArticle.setDescription(article.getDescription());
            articles.add(wxArticle);
        }
        WxMpKefuMessage message = ((NewsBuilder)WxMpKefuMessage.NEWS().articles(articles).toUser(messageBean.getOpenId())).build();
        try {
            wxMpService.getKefuService().sendKefuMessage(message);
        }
        catch (WxErrorException e) {
            logger.error("send kefu news message failed: ", (Throwable)e);
            responseData.setMessage("send kefu news message failed.");
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    private ResponseData sendKefuImage(WxMessageBean messageBean) {
        ResponseData responseData = new ResponseData(false);
        Integer type = this.judgeType(messageBean.getAccountId(), messageBean.getAppId(), messageBean.getWxCode());
        if (type.equals(this.INVALID_DATA) || StringUtils.isEmpty((String)messageBean.getOpenId()) && StringUtils.isEmpty((String)messageBean.getUserIds())) {
            responseData.setMessage("parameter data is invalid");
            return responseData;
        }
        if (type.equals(this.CORP)) {
            return this.sendCpImage(messageBean);
        }
        WechatEnterpriseApp app = this.getWechatEnterpriseApp(messageBean);
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(app.getAccountId());
        WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
        try {
            WxMediaUploadResult uploadMediaRes = wxMpService.getMaterialService().mediaUpload("image", FilenameUtils.getExtension((String)messageBean.getFileName()), (InputStream)new FileInputStream(new File(this.uploadDir + messageBean.getFileName())));
            WxMpKefuMessage message = ((ImageBuilder)WxMpKefuMessage.IMAGE().mediaId(uploadMediaRes.getMediaId()).toUser(messageBean.getOpenId())).build();
            wxMpService.getKefuService().sendKefuMessage(message);
        }
        catch (FileNotFoundException | WxErrorException e) {
            logger.error("send kefu image message failed, ", e);
            responseData.setMessage("send kefu image message failed");
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    private ResponseData sendKefuText(WxMessageBean messageBean) {
        Integer type = this.judgeType(messageBean.getAccountId(), messageBean.getAppId(), messageBean.getWxCode());
        if (type.equals(this.INVALID_DATA) || StringUtils.isEmpty((String)messageBean.getOpenId()) && !type.equals(this.CORP)) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage("parameter data is invalid");
            return responseData;
        }
        if (type.equals(this.CORP)) {
            return this.sendCpText(messageBean);
        }
        ResponseData responseData = new ResponseData(false);
        WechatEnterpriseApp app = this.getWechatEnterpriseApp(messageBean);
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(app.getAccountId());
        WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
        WxMpKefuMessage message = ((me.chanjar.weixin.mp.builder.kefu.TextBuilder)WxMpKefuMessage.TEXT().toUser(messageBean.getOpenId())).content(messageBean.getText()).build();
        try {
            wxMpService.getKefuService().sendKefuMessage(message);
        }
        catch (WxErrorException e) {
            logger.error("send kefu text message failed", (Throwable)e);
            responseData.setMessage("send kefu text message failed.");
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    @Override
    public ResponseData sendTemplateText(WxMessageBean messageBean) {
        System.out.println("****************AccountId:" + messageBean.getAccountId());
        System.out.println("****************AppId:" + messageBean.getAppId());
        System.out.println("****************WxCode:" + messageBean.getWxCode());
        Integer type = this.judgeType(messageBean.getAccountId(), messageBean.getAppId(), messageBean.getWxCode());
        System.out.println("****************type:" + type);
        System.out.println("****************equals:" + type.equals(this.INVALID_DATA) + "---" + StringUtils.isEmpty((String)messageBean.getOpenId()) + "---" + !type.equals(this.CORP));
        if (type.equals(this.INVALID_DATA) || StringUtils.isEmpty((String)messageBean.getOpenId()) && !type.equals(this.CORP)) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage("parameter data is invalid");
            return responseData;
        }
        if (type.equals(this.CORP)) {
            return this.sendCpText(messageBean);
        }
        if (type.equals(this.SERV)) {
            ResponseData responseData = new ResponseData(false);
            WechatEnterpriseApp app = this.getWechatEnterpriseApp(messageBean);
            WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(app.getAccountId());
            WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
            WxMpTemplateMessage templateMessage = WxMpTemplateMessage.builder().toUser(messageBean.getOpenId()).templateId(messageBean.getTemplateId()).url(messageBean.getUrl()).build();
            try {
                wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
                responseData.setSuccess(true);
            }
            catch (WxErrorException e) {
                logger.error("send template message failed{}", (Throwable)e);
                responseData.setMessage("send template message failed." + e.getMessage());
                return responseData;
            }
            responseData.setSuccess(true);
            return responseData;
        }
        ResponseData responseData = new ResponseData(false);
        responseData.setMessage("\u9009\u62e9\u7684\u5fae\u4fe1\u5e94\u7528\u4e0d\u662f\u670d\u52a1\u53f7\u5e94\u7528\u3002");
        return responseData;
    }

    private ResponseData sendCpImage(WxMessageBean messageBean) {
        ResponseData responseData = new ResponseData(false);
        WechatEnterpriseApp app = this.getWechatEnterpriseApp(messageBean);
        Integer agentId = Integer.valueOf(app.getAgentId());
        WxCpService wxCpService = WeChatUtils.initWxCpService(app.getCorpId(), app.getSecret(), Integer.valueOf(app.getAgentId()), this.proxyHost, this.proxyPort);
        String partyIds = WeChatUtils.formatIds(messageBean.getPartyIds(), true);
        String tagIds = WeChatUtils.formatIds(messageBean.getTagIds(), true);
        String userIds = WeChatUtils.formatIds(messageBean.getUserIds(), true);
        try {
            WxMediaUploadResult res = wxCpService.getMediaService().upload("image", new File(this.uploadDir + messageBean.getFileName()));
            WxCpMessage message = StringUtils.isEmpty((String)partyIds) && StringUtils.isEmpty((String)tagIds) && StringUtils.isEmpty((String)userIds) ? ((me.chanjar.weixin.cp.bean.messagebuilder.ImageBuilder)((me.chanjar.weixin.cp.bean.messagebuilder.ImageBuilder)WxCpMessage.IMAGE().mediaId(res.getMediaId()).agentId(agentId)).toUser("@all")).build() : ((me.chanjar.weixin.cp.bean.messagebuilder.ImageBuilder)((me.chanjar.weixin.cp.bean.messagebuilder.ImageBuilder)((me.chanjar.weixin.cp.bean.messagebuilder.ImageBuilder)((me.chanjar.weixin.cp.bean.messagebuilder.ImageBuilder)WxCpMessage.IMAGE().mediaId(res.getMediaId()).agentId(agentId)).toParty(partyIds)).toTag(tagIds)).toUser(userIds)).build();
            wxCpService.messageSend(message);
        }
        catch (WxErrorException e) {
            logger.error("upload media file failed or send image message failed\uff1a", (Throwable)e);
            responseData.setMessage("upload media file failed or send image message failed\uff1a" + e.getMessage());
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    private ResponseData sendMpImage(WxMessageBean messageBean) {
        ResponseData responseData = new ResponseData(false);
        WechatEnterpriseApp app = this.getWechatEnterpriseApp(messageBean);
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(app.getAccountId());
        WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
        Object[] openIds = WeChatUtils.formatIds(messageBean.getOpenIds());
        String tagId = messageBean.getTagId();
        try {
            WxMpMaterial material = new WxMpMaterial();
            material.setFile(new File(this.uploadDir + messageBean.getFileName()));
            material.setName(messageBean.getFileName());
            WxMpMaterialUploadResult uploadMaterialRes = wxMpService.getMaterialService().materialFileUpload("image", material);
            if (ArrayUtils.isNotEmpty((Object[])openIds)) {
                WxMpMassOpenIdsMessage massMessage = new WxMpMassOpenIdsMessage();
                massMessage.setMsgType("image");
                massMessage.setMediaId(uploadMaterialRes.getMediaId());
                for (Object openId : openIds) {
                    if (!StringUtils.isNotEmpty((String)openId)) continue;
                    massMessage.getToUsers().add(openId);
                }
                wxMpService.getMassMessageService().massOpenIdsMessageSend(massMessage);
            } else {
                WxMpMassTagMessage tagMessage = new WxMpMassTagMessage();
                tagMessage.setMsgType("image");
                tagMessage.setMediaId(uploadMaterialRes.getMediaId());
                if (StringUtils.isNotEmpty((String)tagId)) {
                    tagMessage.setTagId(Long.valueOf(tagId));
                } else {
                    tagMessage.setSendAll(true);
                }
                wxMpService.getMassMessageService().massGroupMessageSend(tagMessage);
            }
        }
        catch (WxErrorException e) {
            logger.error("upload media file failed or send image message failed\uff1a", (Throwable)e);
            responseData.setMessage("upload media file failed or send image message failed\uff1a" + e.getMessage());
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    @Override
    public ResponseData sendImage(IRequest requestContext, WxMessageBean messageBean) {
        int type = this.judgeType(messageBean.getAccountId(), messageBean.getAppId(), messageBean.getWxCode());
        if (type == this.INVALID_DATA) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage("invalid param data value.");
            return responseData;
        }
        if (type == this.CORP) {
            return this.sendCpImage(messageBean);
        }
        if (type == this.SERV || type == this.SUBS) {
            return this.sendMpImage(messageBean);
        }
        ResponseData responseData = new ResponseData(false);
        responseData.setMessage("invalid account type");
        return responseData;
    }

    @Override
    public String uploadPicture(IRequest requestCtx, MultipartFile image) {
        String originalFileName = image.getOriginalFilename();
        String fileName = System.currentTimeMillis() + originalFileName;
        File dest = new File(this.uploadDir + fileName);
        if (WeChatUtils.compressImage(image, dest)) {
            return fileName;
        }
        return null;
    }

    @Override
    public JSONObject uploadThumbPicture(IRequest requestCtx, MultipartFile image, Long accountId) {
        if (accountId == null) {
            logger.error("accountId can not be null");
            return null;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(accountId);
        if (account == null) {
            logger.error("target account can not be found");
            return null;
        }
        String originalFileName = image.getOriginalFilename();
        String fileName = System.currentTimeMillis() + originalFileName;
        File dest = new File(this.uploadDir + fileName);
        if (WeChatUtils.compressImage(image, dest)) {
            WxMediaUploadResult uploadMediaRes;
            WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
            try {
                uploadMediaRes = wxMpService.getMaterialService().mediaUpload("image", FilenameUtils.getExtension((String)fileName), (InputStream)new FileInputStream(dest));
            }
            catch (FileNotFoundException | WxErrorException e) {
                logger.error("upload media file failed or send image message failed\uff1a", e);
                return null;
            }
            String mediaId = uploadMediaRes.getMediaId();
            String url = this.uploadDir + fileName;
            MPNewsThumbPicture mpNewsThumbPicture = new MPNewsThumbPicture();
            mpNewsThumbPicture.setOriginalName(originalFileName);
            mpNewsThumbPicture.setFileName(fileName);
            mpNewsThumbPicture.setUrl(url);
            mpNewsThumbPicture.setMediaId(mediaId);
            mpNewsThumbPicture.setAccountId(accountId);
            this.mpNewsThumbPictureMapper.insertSelective(mpNewsThumbPicture);
            JSONObject data = new JSONObject();
            data.put((Object)"mediaId", (Object)mediaId);
            data.put((Object)"fileName", (Object)fileName);
            return data;
        }
        return null;
    }

    private ResponseData sendCpText(WxMessageBean messageBean) {
        ResponseData responseData = new ResponseData(false);
        WechatEnterpriseApp app = this.getWechatEnterpriseApp(messageBean);
        Integer agentId = Integer.valueOf(app.getAgentId());
        WxCpService wxCpService = WeChatUtils.initWxCpService(app.getCorpId(), app.getSecret(), Integer.valueOf(app.getAgentId()), this.proxyHost, this.proxyPort);
        String partyIds = WeChatUtils.formatIds(messageBean.getPartyIds(), true);
        String tagIds = WeChatUtils.formatIds(messageBean.getTagIds(), true);
        String userIds = WeChatUtils.formatIds(messageBean.getUserIds(), true);
        WxCpMessage wxCpMessage = StringUtils.isEmpty((String)partyIds) && StringUtils.isEmpty((String)tagIds) && StringUtils.isEmpty((String)userIds) ? ((TextBuilder)((TextBuilder)WxCpMessage.TEXT().agentId(agentId)).content(messageBean.getText()).toUser("@all")).build() : ((TextBuilder)((TextBuilder)((TextBuilder)((TextBuilder)WxCpMessage.TEXT().agentId(agentId)).content(messageBean.getText()).toParty(partyIds)).toTag(tagIds)).toUser(userIds)).build();
        try {
            wxCpService.messageSend(wxCpMessage);
        }
        catch (WxErrorException e) {
            logger.error("send text message failed: ", (Throwable)e);
            responseData.setMessage("send text message failed: " + e.getMessage());
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    private WechatEnterpriseApp getWechatEnterpriseApp(WxMessageBean messageBean) {
        WechatEnterpriseApp app;
        if (StringUtils.isNotEmpty((String)messageBean.getWxCode())) {
            WechatEnterpriseApp dto = new WechatEnterpriseApp();
            dto.setWxCode(messageBean.getWxCode());
            app = this.wechatEnterpriseAppMapper.select(dto).get(0);
        } else {
            app = (WechatEnterpriseApp)this.wechatEnterpriseAppMapper.selectByPrimaryKey(messageBean.getAppId());
        }
        return app;
    }

    private ResponseData sendMpText(WxMessageBean messageBean) {
        ResponseData responseData = new ResponseData(false);
        WechatEnterpriseApp app = this.getWechatEnterpriseApp(messageBean);
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(app.getAccountId());
        WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
        Object[] openIds = WeChatUtils.formatIds(messageBean.getOpenIds());
        String tagId = messageBean.getTagId();
        try {
            if (ArrayUtils.isNotEmpty((Object[])openIds)) {
                WxMpMassOpenIdsMessage massMessage = new WxMpMassOpenIdsMessage();
                massMessage.setMsgType("text");
                massMessage.setContent(messageBean.getText());
                for (Object openId : openIds) {
                    if (!StringUtils.isNotEmpty((String)openId)) continue;
                    massMessage.getToUsers().add(openId);
                }
                wxMpService.getMassMessageService().massOpenIdsMessageSend(massMessage);
            } else {
                WxMpMassTagMessage tagMessage = new WxMpMassTagMessage();
                tagMessage.setMsgType("text");
                tagMessage.setContent(messageBean.getText());
                if (StringUtils.isNotEmpty((String)tagId)) {
                    tagMessage.setTagId(Long.valueOf(tagId));
                } else {
                    tagMessage.setSendAll(true);
                }
                wxMpService.getMassMessageService().massGroupMessageSend(tagMessage);
            }
        }
        catch (WxErrorException e) {
            logger.error("send text message failed: ", (Throwable)e);
            responseData.setMessage("send text message failed: " + e.getMessage());
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    @Override
    public ResponseData sendText(IRequest requestContext, WxMessageBean messageBean) {
        int type = this.judgeType(messageBean.getAccountId(), messageBean.getAppId(), messageBean.getWxCode());
        if (type == this.INVALID_DATA) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage("invalid param data value.");
            return responseData;
        }
        if (type == this.CORP) {
            return this.sendCpText(messageBean);
        }
        if (type == this.SERV || type == this.SUBS) {
            return this.sendMpText(messageBean);
        }
        ResponseData responseData = new ResponseData(false);
        responseData.setMessage("invalid account type");
        return responseData;
    }

    private ResponseData sendCpMPNews(WxMessageBean messageBean) {
        ResponseData responseData = new ResponseData(false);
        WechatEnterpriseApp app = this.getWechatEnterpriseApp(messageBean);
        Integer agentId = Integer.valueOf(app.getAgentId());
        WxCpService wxCpService = WeChatUtils.initWxCpService(app.getCorpId(), app.getSecret(), Integer.valueOf(app.getAgentId()), this.proxyHost, this.proxyPort);
        List<Article> articles = messageBean.getArticles();
        ArrayList<NewArticle> newArticles = new ArrayList<NewArticle>();
        for (Article article : articles) {
            NewArticle newArticle = new NewArticle();
            newArticle.setDescription(article.getDescription());
            newArticle.setPicUrl(article.getPicUrl());
            newArticle.setTitle(article.getTitle());
            newArticle.setUrl(article.getUrl());
            newArticles.add(newArticle);
        }
        String partyIds = WeChatUtils.formatIds(messageBean.getPartyIds(), true);
        String tagIds = WeChatUtils.formatIds(messageBean.getTagIds(), true);
        String userIds = WeChatUtils.formatIds(messageBean.getUserIds(), true);
        WxCpMessage message = StringUtils.isEmpty((String)partyIds) && StringUtils.isEmpty((String)tagIds) && StringUtils.isEmpty((String)userIds) ? ((me.chanjar.weixin.cp.bean.messagebuilder.NewsBuilder)((me.chanjar.weixin.cp.bean.messagebuilder.NewsBuilder)WxCpMessage.NEWS().toUser("@all")).agentId(agentId)).articles(newArticles).build() : ((me.chanjar.weixin.cp.bean.messagebuilder.NewsBuilder)((me.chanjar.weixin.cp.bean.messagebuilder.NewsBuilder)((me.chanjar.weixin.cp.bean.messagebuilder.NewsBuilder)((me.chanjar.weixin.cp.bean.messagebuilder.NewsBuilder)WxCpMessage.NEWS().agentId(agentId)).articles(newArticles).toParty(partyIds)).toTag(tagIds)).toUser(userIds)).build();
        try {
            wxCpService.messageSend(message);
        }
        catch (Exception e) {
            logger.error("send MPNews message failed: ", (Throwable)e);
            responseData.setMessage("send MPNews message failed: " + e.getMessage());
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    private ResponseData sendMpNews(WxMessageBean messageBean) {
        ResponseData responseData = new ResponseData(false);
        WechatEnterpriseApp app = this.getWechatEnterpriseApp(messageBean);
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(app.getAccountId());
        WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
        WxMpMassNews news = new WxMpMassNews();
        for (Article article : messageBean.getArticles()) {
            WxMpMassNews.WxMpMassNewsArticle newsArticle = new WxMpMassNews.WxMpMassNewsArticle();
            newsArticle.setAuthor(article.getAuthor());
            newsArticle.setContent(article.getContent());
            newsArticle.setContentSourceUrl(article.getContentSourceUrl());
            newsArticle.setDigest(article.getDescription());
            newsArticle.setThumbMediaId(article.getThumbMediaId());
            newsArticle.setShowCoverPic(article.getShowCoverPic().booleanValue());
            newsArticle.setTitle(article.getTitle());
            news.addArticle(newsArticle);
        }
        Object[] openIds = WeChatUtils.formatIds(messageBean.getOpenIds());
        String tagId = messageBean.getTagId();
        try {
            WxMpMassUploadResult massUploadResult = wxMpService.getMassMessageService().massNewsUpload(news);
            if (ArrayUtils.isNotEmpty((Object[])openIds)) {
                WxMpMassOpenIdsMessage massMessage = new WxMpMassOpenIdsMessage();
                massMessage.setMsgType("mpnews");
                massMessage.setMediaId(massUploadResult.getMediaId());
                for (Object openId : openIds) {
                    massMessage.getToUsers().add(openId);
                }
                wxMpService.getMassMessageService().massOpenIdsMessageSend(massMessage);
            } else {
                WxMpMassTagMessage tagMessage = new WxMpMassTagMessage();
                tagMessage.setMsgType("mpnews");
                tagMessage.setMediaId(massUploadResult.getMediaId());
                if (StringUtils.isNotEmpty((String)tagId)) {
                    tagMessage.setTagId(Long.valueOf(tagId));
                } else {
                    tagMessage.setSendAll(true);
                }
                wxMpService.getMassMessageService().massGroupMessageSend(tagMessage);
            }
        }
        catch (WxErrorException e) {
            logger.error("send MPNews message failed: ", (Throwable)e);
            responseData.setMessage("send MPNews message failed: " + e.getMessage());
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    @Override
    public ResponseData sendMPNews(IRequest iRequest, WxMessageBean messageBean) {
        int type = this.judgeType(messageBean.getAccountId(), messageBean.getAppId(), messageBean.getWxCode());
        if (type == this.INVALID_DATA) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage("invalid param data value.");
            return responseData;
        }
        if (type == this.CORP) {
            return this.sendCpMPNews(messageBean);
        }
        if (type == this.SERV || type == this.SUBS) {
            return this.sendMpNews(messageBean);
        }
        ResponseData responseData = new ResponseData(false);
        responseData.setMessage("invalid account type");
        return responseData;
    }

    @Override
    public Integer judgeType(Long accountId, Long appId, String wxCode) {
        if (StringUtils.isNotEmpty((String)wxCode)) {
            WechatEnterpriseApp wea = new WechatEnterpriseApp();
            wea.setWxCode(wxCode);
            List<WechatEnterpriseApp> apps = this.wechatEnterpriseAppMapper.select(wea);
            if (CollectionUtils.isEmpty(apps) || apps.size() > 1) {
                logger.error("one wxCode found duplicate app.");
                return this.INVALID_DATA;
            }
            WechatEnterpriseApp app = apps.get(0);
            WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(app.getAccountId());
            if (account == null) {
                logger.error("app has no account.");
                return this.INVALID_DATA;
            }
            return account.getAccountType();
        }
        if (accountId != null) {
            WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(accountId);
            if (account == null) {
                if (appId != null) {
                    WechatEnterpriseApp app = (WechatEnterpriseApp)this.wechatEnterpriseAppMapper.selectByPrimaryKey(appId);
                    if (app == null) {
                        logger.error("target wechat enterprise app can not be found!");
                        return this.INVALID_DATA;
                    }
                    return this.CORP;
                }
                logger.error("target wechat account can not be found!");
                return this.INVALID_DATA;
            }
            Integer accountType = account.getAccountType();
            if (!(accountType.equals(this.CORP) || accountType.equals(this.SERV) || accountType.equals(this.SUBS))) {
                return this.INVALID_DATA;
            }
            if (accountType.equals(this.CORP)) {
                if (appId == null) {
                    logger.error("appId can not be null when your account type is qiye");
                    return this.INVALID_DATA;
                }
                WechatEnterpriseApp app = (WechatEnterpriseApp)this.wechatEnterpriseAppMapper.selectByPrimaryKey(appId);
                if (app == null) {
                    logger.error("target wechat enterprise app can not be found!");
                    return this.INVALID_DATA;
                }
                return this.CORP;
            }
            return accountType;
        }
        if (appId == null) {
            logger.error("appId & accountId can not both be null");
            return this.INVALID_DATA;
        }
        WechatEnterpriseApp app = (WechatEnterpriseApp)this.wechatEnterpriseAppMapper.selectByPrimaryKey(appId);
        if (app == null) {
            logger.error("target wechat app can not be found!");
            return this.INVALID_DATA;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(app.getAccountId());
        if (account == null) {
            logger.error("target wechat account can not be found!");
            return this.INVALID_DATA;
        }
        if (!(account.getAccountType().equals(this.CORP) || account.getAccountType().equals(this.SERV) || account.getAccountType().equals(this.SUBS))) {
            return this.INVALID_DATA;
        }
        return account.getAccountType();
    }
}

