/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.wechat.dto.EnterpriseAppDepartment;
import hls.support.core.wechat.dto.EnterpriseAppMember;
import hls.support.core.wechat.dto.MemberAdditionalInfo;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatDepartment;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.dto.WechatMember;
import hls.support.core.wechat.dto.WechatMemberDepartment;
import hls.support.core.wechat.dto.WechatMemberTag;
import hls.support.core.wechat.dto.WechatTag;
import hls.support.core.wechat.mapper.AppDepartmentMapper;
import hls.support.core.wechat.mapper.AppMemberMapper;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatDepartmentMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.mapper.WechatMemberAdditionalInfoMapper;
import hls.support.core.wechat.mapper.WechatMemberDepartmentMapper;
import hls.support.core.wechat.mapper.WechatMemberMapper;
import hls.support.core.wechat.mapper.WechatMemberTagMapper;
import hls.support.core.wechat.mapper.WechatTagMapper;
import hls.support.core.wechat.service.IWechatAccountService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.cp.api.impl.WxCpServiceImpl;
import me.chanjar.weixin.cp.bean.WxCpDepart;
import me.chanjar.weixin.cp.bean.WxCpTag;
import me.chanjar.weixin.cp.bean.WxCpUser;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.config.WxCpInMemoryConfigStorage;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.WxMpInMemoryConfigStorage;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.bean.result.WxMpUserList;
import me.chanjar.weixin.mp.bean.tag.WxUserTag;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class WechatAccountServiceImpl
extends BaseServiceImpl<WechatAccount>
implements IWechatAccountService {
    private static Logger logger = LoggerFactory.getLogger(WechatAccountServiceImpl.class);
    @Autowired
    private WechatAccountMapper wechatAccountMapper;
    @Autowired
    private WechatDepartmentMapper wechatDepartmentMapper;
    @Autowired
    private WechatTagMapper wechatTagMapper;
    @Autowired
    private WechatMemberMapper wechatMemberMapper;
    @Autowired
    private WechatMemberDepartmentMapper wechatMemberDepartmentMapper;
    @Autowired
    private WechatMemberTagMapper wechatMemberTagMapper;
    @Autowired
    private WechatMemberAdditionalInfoMapper memberAdditionalInfoMapper;
    @Autowired
    private WechatEnterpriseAppMapper enterpriseAppMapper;
    @Autowired
    private AppDepartmentMapper appDepartmentMapper;
    @Autowired
    private AppMemberMapper appMemberMapper;
    @Value(value="#{configProperties['http.proxy.port']}")
    private Integer proxyPort;
    @Value(value="#{configProperties['http.proxy.host']}")
    private String proxyHost;

    private WechatAccount validateParam(Long accountId) {
        if (accountId != null) {
            WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(accountId);
            if (account != null) {
                return account;
            }
            logger.error("could not found target wechat account");
        }
        logger.error("accountId is null.");
        return null;
    }

    private void clearCommonData(Long accountId) {
        WechatMember m = new WechatMember();
        m.setAccountId(accountId);
        List<WechatMember> wechatMembers = this.wechatMemberMapper.select(m);
        if (CollectionUtils.isNotEmpty(wechatMembers)) {
            for (WechatMember member : wechatMembers) {
                MemberAdditionalInfo memberAdditionalInfo = new MemberAdditionalInfo();
                memberAdditionalInfo.setMemberId(member.getMemberId());
                this.memberAdditionalInfoMapper.delete(memberAdditionalInfo);
                this.wechatMemberMapper.delete(member);
            }
        }
        WechatTag wt = new WechatTag();
        wt.setAccountId(accountId);
        List<WechatTag> wts = this.wechatTagMapper.select(wt);
        if (CollectionUtils.isNotEmpty(wts)) {
            for (WechatTag wechatTag : wts) {
                WechatMemberTag wmt = new WechatMemberTag();
                wmt.setTagId(wechatTag.getId());
                this.wechatMemberTagMapper.delete(wmt);
            }
        }
        this.wechatTagMapper.delete(wt);
    }

    private ResponseData synchronizeCpData(WechatAccount account) {
        List<WechatMember> members;
        WechatMember member;
        List tagList;
        List departList;
        ResponseData responseData = new ResponseData(false);
        WechatEnterpriseApp wa = new WechatEnterpriseApp();
        wa.setAccountId(account.getAccountId());
        List<WechatEnterpriseApp> enterpriseApps = this.enterpriseAppMapper.select(wa);
        WxCpInMemoryConfigStorage config = new WxCpInMemoryConfigStorage();
        config.setCorpId(account.getAppId());
        config.setCorpSecret(account.getSecret());
        if (this.proxyHost != null) {
            config.setHttpProxyHost(this.proxyHost);
        }
        if (this.proxyPort != null) {
            config.setHttpProxyPort(this.proxyPort.intValue());
        }
        WxCpServiceImpl wxCpService = new WxCpServiceImpl();
        wxCpService.setWxCpConfigStorage((WxCpConfigStorage)config);
        try {
            departList = wxCpService.getDepartmentService().listAll();
            tagList = wxCpService.getTagService().listAll();
        }
        catch (WxErrorException e) {
            logger.error("fetch department or tag list from wechat server failed:", (Throwable)e);
            responseData.setMessage("fetch department or tag list from wechat server failed");
            return responseData;
        }
        WechatDepartment wd = new WechatDepartment();
        wd.setAccountId(account.getAccountId());
        List<WechatDepartment> wds = this.wechatDepartmentMapper.select(wd);
        if (CollectionUtils.isNotEmpty(wds)) {
            for (WechatDepartment wechatDepartment : wds) {
                WechatMemberDepartment wmd = new WechatMemberDepartment();
                wmd.setDepartmentId(wechatDepartment.getId());
                this.wechatMemberDepartmentMapper.delete(wmd);
            }
        }
        this.wechatDepartmentMapper.delete(wd);
        ArrayList<WechatDepartment> wechatDepartments = new ArrayList<WechatDepartment>();
        if (CollectionUtils.isNotEmpty((Collection)departList)) {
            for (WxCpDepart depart : departList) {
                WechatDepartment department = new WechatDepartment();
                department.setAccountId(account.getAccountId());
                department.setDepartmentId(depart.getId());
                department.setDepartmentName(depart.getName());
                department.setParentId(depart.getParentId());
                department.setDepartmentOrder(depart.getOrder());
                this.wechatDepartmentMapper.insertSelective(department);
                wechatDepartments.add(department);
            }
        }
        if (CollectionUtils.isNotEmpty(wechatDepartments)) {
            for (WechatDepartment department : wechatDepartments) {
                List users;
                try {
                    users = wxCpService.getUserService().listByDepartment(department.getDepartmentId(), Boolean.valueOf(false), Integer.valueOf(0));
                }
                catch (WxErrorException e) {
                    logger.error("fetch users data which based on departmentId from wechat server failed: ", (Throwable)e);
                    responseData.setMessage("fetch users data which based on departmentId from wechat server failed.");
                    return responseData;
                }
                if (!CollectionUtils.isNotEmpty((Collection)users)) continue;
                for (WxCpUser user : users) {
                    WechatMember wechatMember = new WechatMember();
                    wechatMember.setUserId(user.getUserId());
                    wechatMember.setAccountId(account.getAccountId());
                    member = new WechatMember();
                    members = this.wechatMemberMapper.select(wechatMember);
                    if (CollectionUtils.isEmpty(members)) {
                        BeanUtils.copyProperties((Object)user, (Object)member);
                        member.setAccountId(account.getAccountId());
                        this.wechatMemberMapper.insertSelective(member);
                        MemberAdditionalInfo memberAdditionalInfo = new MemberAdditionalInfo();
                        BeanUtils.copyProperties((Object)user, (Object)memberAdditionalInfo);
                        memberAdditionalInfo.setMemberId(member.getMemberId());
                        this.memberAdditionalInfoMapper.insertSelective(memberAdditionalInfo);
                    } else {
                        if (members.size() > 1) {
                            logger.warn("duplicate user_id data in table wechat_member!");
                            responseData.setMessage("duplicate user_id data in table wechat_member!");
                            return responseData;
                        }
                        member = members.get(0);
                    }
                    WechatMemberDepartment memberDepartment = new WechatMemberDepartment();
                    memberDepartment.setDepartmentId(department.getId());
                    memberDepartment.setMemberId(member.getMemberId());
                    this.wechatMemberDepartmentMapper.insertSelective(memberDepartment);
                }
            }
        }
        ArrayList<WechatTag> arrayList = new ArrayList<WechatTag>();
        if (CollectionUtils.isNotEmpty((Collection)tagList)) {
            for (WxCpTag tag : tagList) {
                WechatTag wechatTag = new WechatTag();
                wechatTag.setAccountId(account.getAccountId());
                wechatTag.setTagName(tag.getName());
                wechatTag.setTagId(tag.getId());
                this.wechatTagMapper.insertSelective(wechatTag);
                arrayList.add(wechatTag);
            }
        }
        if (CollectionUtils.isNotEmpty(arrayList)) {
            for (WechatTag wechatTag : arrayList) {
                List users;
                try {
                    users = wxCpService.getTagService().listUsersByTagId(wechatTag.getTagId());
                }
                catch (WxErrorException e) {
                    logger.error("fetch users data which based on tagId failed: ", (Throwable)e);
                    responseData.setMessage("fetch users data which based on tagId failed.");
                    return responseData;
                }
                if (!CollectionUtils.isNotEmpty((Collection)users)) continue;
                for (WxCpUser user : users) {
                    member = new WechatMember();
                    member.setUserId(user.getUserId());
                    members = this.wechatMemberMapper.select(member);
                    if (CollectionUtils.isEmpty(members)) continue;
                    if (members.size() > 1) {
                        logger.warn("duplicate user_id data in table wechat_member!");
                        responseData.setMessage("duplicate user_id data in table wechat_member!");
                        return responseData;
                    }
                    WechatMemberTag memberTag = new WechatMemberTag();
                    member = this.wechatMemberMapper.select(member).get(0);
                    memberTag.setTagId(wechatTag.getId());
                    memberTag.setMemberId(member.getMemberId());
                    this.wechatMemberTagMapper.insertSelective(memberTag);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(enterpriseApps)) {
            for (WechatEnterpriseApp app : enterpriseApps) {
                List departs;
                config.setCorpSecret(app.getSecret());
                wxCpService.setWxCpConfigStorage((WxCpConfigStorage)config);
                EnterpriseAppMember am = new EnterpriseAppMember();
                am.setAppId(app.getId());
                this.appMemberMapper.delete(am);
                EnterpriseAppDepartment ad = new EnterpriseAppDepartment();
                ad.setAppId(app.getId());
                this.appDepartmentMapper.delete(ad);
                try {
                    departs = wxCpService.getDepartmentService().listAll();
                }
                catch (WxErrorException e) {
                    logger.error("fetch department data by current account's apps failed, the error app's agentId is " + app.getAgentId(), (Throwable)e);
                    responseData.setMessage("fetch department data by current account's apps failed, the error app's agentId is " + app.getAgentId());
                    return responseData;
                }
                if (!CollectionUtils.isNotEmpty((Collection)departs)) continue;
                for (WxCpDepart depart : departs) {
                    List users;
                    WechatDepartment department = new WechatDepartment();
                    department.setAccountId(account.getAccountId());
                    department.setDepartmentId(depart.getId());
                    List<WechatDepartment> wechatDepartmentList = this.wechatDepartmentMapper.select(department);
                    if (CollectionUtils.isEmpty(wechatDepartmentList)) continue;
                    if (wechatDepartmentList.size() > 1) {
                        logger.warn("duplicate account_id & department_id data in table wechat_department!");
                        responseData.setMessage("duplicate account_id & department_id data in table wechat_department!");
                        return responseData;
                    }
                    WechatDepartment wechatDepartment = wechatDepartmentList.get(0);
                    EnterpriseAppDepartment appDepartment = new EnterpriseAppDepartment();
                    appDepartment.setAppId(app.getId());
                    appDepartment.setDepartmentId(wechatDepartment.getId());
                    this.appDepartmentMapper.insertSelective(appDepartment);
                    try {
                        users = wxCpService.getUserService().listSimpleByDepartment(depart.getId(), Boolean.valueOf(true), Integer.valueOf(0));
                    }
                    catch (WxErrorException e) {
                        logger.error("fetch users data by current app's department failed, the error app's agentId is {} ", (Object)app.getAgentId(), (Object)e);
                        responseData.setMessage("fetch users data by current app's department failed, the error app's agentId is " + app.getAgentId());
                        return responseData;
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)users)) continue;
                    for (WxCpUser user : users) {
                        WechatMember wechatMember = new WechatMember();
                        wechatMember.setUserId(user.getUserId());
                        List<WechatMember> members2 = this.wechatMemberMapper.select(wechatMember);
                        if (CollectionUtils.isEmpty(members2)) continue;
                        if (members2.size() > 1) {
                            logger.warn("duplicate user_id data in table wechat_member!");
                            responseData.setMessage("duplicate user_id data in table wechat_member!");
                            return responseData;
                        }
                        WechatMember member2 = members2.get(0);
                        EnterpriseAppMember appMember = new EnterpriseAppMember();
                        appMember.setMemberId(member2.getMemberId());
                        appMember.setAppId(app.getId());
                        if (!CollectionUtils.isEmpty(this.appMemberMapper.select(appMember))) continue;
                        this.appMemberMapper.insertSelective(appMember);
                    }
                }
            }
        }
        responseData.setSuccess(true);
        return responseData;
    }

    private ResponseData synchronizeMpData(WechatAccount account) {
        WxMpUserList userList;
        List tagList;
        ResponseData responseData = new ResponseData(false);
        WxMpInMemoryConfigStorage config = new WxMpInMemoryConfigStorage();
        config.setAppId(account.getAppId());
        config.setSecret(account.getSecret());
        if (this.proxyHost != null) {
            config.setHttpProxyHost(this.proxyHost);
        }
        if (this.proxyPort != null) {
            config.setHttpProxyPort(this.proxyPort.intValue());
        }
        WxMpServiceImpl wxMpService = new WxMpServiceImpl();
        wxMpService.setWxMpConfigStorage((WxMpConfigStorage)config);
        try {
            tagList = wxMpService.getUserTagService().tagGet();
            userList = wxMpService.getUserService().userList(null);
        }
        catch (WxErrorException e) {
            logger.error("fetch tag or user list from wechat server failed: ", (Throwable)e);
            responseData.setMessage("fetch tag or user list from wechat server failed");
            return responseData;
        }
        for (WxUserTag tag : tagList) {
            WechatTag wechatTag = new WechatTag();
            wechatTag.setAccountId(account.getAccountId());
            wechatTag.setTagName(tag.getName());
            wechatTag.setTagId(String.valueOf(tag.getId()));
            this.wechatTagMapper.insertSelective(wechatTag);
        }
        List openIds = userList.getOpenids();
        if (CollectionUtils.isNotEmpty((Collection)openIds)) {
            for (String openId : openIds) {
                Long[] tagIds;
                WxMpUser user;
                try {
                    user = wxMpService.getUserService().userInfo(openId);
                }
                catch (WxErrorException e) {
                    logger.error("fetch user info by openid failed,", (Throwable)e);
                    responseData.setMessage("fetch user info by openid failed.");
                    return responseData;
                }
                WechatMember member = new WechatMember();
                MemberAdditionalInfo additionalInfo = new MemberAdditionalInfo();
                member.setOpenId(user.getOpenId());
                member.setGender(String.valueOf(user.getSexId()));
                member.setAccountId(account.getAccountId());
                member.setName(user.getNickname());
                member.setAvatar(user.getHeadImgUrl());
                this.wechatMemberMapper.insertSelective(member);
                BeanUtils.copyProperties((Object)user, (Object)additionalInfo);
                additionalInfo.setGroupid(user.getGroupId());
                additionalInfo.setMemberId(member.getMemberId());
                this.memberAdditionalInfoMapper.insertSelective(additionalInfo);
                for (Long tagId : tagIds = user.getTagIds()) {
                    WechatTag wechatTag = new WechatTag();
                    wechatTag.setTagId(String.valueOf(tagId));
                    wechatTag.setAccountId(account.getAccountId());
                    List<WechatTag> tags = this.wechatTagMapper.select(wechatTag);
                    if (!CollectionUtils.isNotEmpty(tags)) continue;
                    WechatMemberTag memberTag = new WechatMemberTag();
                    memberTag.setMemberId(member.getMemberId());
                    memberTag.setTagId(tags.get(0).getId());
                    this.wechatMemberTagMapper.insertSelective(memberTag);
                }
            }
        }
        responseData.setSuccess(true);
        return responseData;
    }

    @Override
    public ResponseData synchronizeData(IRequest requestContext, Long accountId) {
        ResponseData responseData = new ResponseData(false);
        WechatAccount account = this.validateParam(accountId);
        if (account != null) {
            this.clearCommonData(accountId);
            int accountType = account.getAccountType();
            if (accountType == WechatAccount.CORP) {
                return this.synchronizeCpData(account);
            }
            if (accountType == WechatAccount.SUBS || accountType == WechatAccount.SERV) {
                return this.synchronizeMpData(account);
            }
            logger.error("account type is incorrect");
            responseData.setMessage("account type is incorrect");
            return responseData;
        }
        responseData.setMessage("target weixin account can not be found");
        return responseData;
    }
}

