/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.wechat.dto.NotificationContent;
import hls.support.core.wechat.dto.NotificationTemplate;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.formbean.WxMessageBean;
import hls.support.core.wechat.mapper.NotificationTemplateMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.service.INotificationContentService;
import hls.support.core.wechat.service.INotificationTemplateService;
import hls.support.core.wechat.service.IWechatMessageService;
import hls.support.core.wechat.utils.WechatNotificationUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class NotificationTemplateServiceImpl
extends BaseServiceImpl<NotificationTemplate>
implements INotificationTemplateService {
    @Autowired
    NotificationTemplateMapper notificationTemplateMapper;
    @Autowired
    IWechatMessageService wechatMessageService;
    @Autowired
    WechatEnterpriseAppMapper wechatEnterpriseAppMapper;
    @Autowired
    INotificationContentService notificationContentService;
    @Value(value="#{configProperties['domain']}")
    private String domain;

    @Override
    public ResponseData sendNotication(IRequest iRequest, Map map) {
        ResponseData responseData = new ResponseData(false);
        if (map.containsKey("templateCode")) {
            String templateCode = (String)map.get("templateCode");
            String openId = (String)map.get("openId");
            String userIds = (String)map.get("userIds");
            String partyIds = (String)map.get("partyIds");
            String tagIds = (String)map.get("tagIds");
            NotificationTemplate notificationTemplate = new NotificationTemplate();
            notificationTemplate.setTemplateCode(templateCode);
            List<NotificationTemplate> notificationTemplates = this.notificationTemplateMapper.select(notificationTemplate);
            if (CollectionUtils.isEmpty(notificationTemplates)) {
                return responseData;
            }
            String content = notificationTemplates.get(0).getContent();
            Long appId = notificationTemplates.get(0).getAppId();
            String templateTagIds = notificationTemplates.get(0).getTagIds();
            String templateKey = notificationTemplates.get(0).getTemplateKey();
            String message = WechatNotificationUtil.initMessage(content, map);
            NotificationContent notificationContent = new NotificationContent();
            notificationContent.setContent(message);
            NotificationContent noticeContent = this.notificationContentService.insertSelective(iRequest, notificationContent);
            String url = this.domain + "weChat/wechat_notification_content.view?id=" + noticeContent.getId();
            if (StringUtils.isEmpty((CharSequence)message)) {
                responseData.setMessage("\u67d0\u4e9b\u6a21\u677f\u66ff\u6362\u503c\u672a\u88ab\u4f20\u5165\u6216\u8005\u4f20\u5165\u7684\u66ff\u6362\u503c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u548c\u4f20\u5165\u7684\u66ff\u6362\u503c\uff01");
                return responseData;
            }
            WxMessageBean messageBean = new WxMessageBean();
            WechatEnterpriseApp app = new WechatEnterpriseApp();
            app.setId(appId);
            Long accountId = ((WechatEnterpriseApp)this.wechatEnterpriseAppMapper.selectByPrimaryKey(app)).getAccountId();
            messageBean.setMessageType("text");
            messageBean.setAppId(appId);
            messageBean.setText(message);
            if (StringUtils.isEmpty((CharSequence)tagIds)) {
                tagIds = templateTagIds;
            }
            messageBean.setOpenId(openId);
            messageBean.setAccountId(accountId);
            messageBean.setUserIds(userIds);
            messageBean.setPartyIds(partyIds);
            messageBean.setTagIds(tagIds);
            messageBean.setUrl(url);
            messageBean.setTemplateId(templateKey);
            return this.wechatMessageService.sendTemplateText(messageBean);
        }
        responseData.setMessage("\u53c2\u6570\u672a\u4f20\u5b8c\u6574");
        return responseData;
    }

    @Override
    public List<NotificationTemplate> query(IRequest iRequest, NotificationTemplate notificationTemplate, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        return this.notificationTemplateMapper.query(notificationTemplate);
    }
}

