/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.service.impl;

import com.hand.hap.mybatis.entity.Example;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.service.IJSSDKService;
import hls.support.core.wechat.utils.WeChatUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.mp.api.WxMpService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class JSSDKServiceImpl
implements IJSSDKService {
    private static Logger logger = LoggerFactory.getLogger(JSSDKServiceImpl.class);
    @Autowired
    private WechatEnterpriseAppMapper appMapper;
    @Autowired
    private WechatAccountMapper accountMapper;
    private String ENCRYPT_TYPE = "utf-8";
    @Value(value="#{configProperties['http.proxy.port']}")
    private Integer proxyPort;
    @Value(value="#{configProperties['http.proxy.host']}")
    private String proxyHost;

    @Override
    public Map<String, Object> getWxConfig(String wxCode, String clientUrl, HttpServletRequest request) {
        String ticket;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", false);
        if (StringUtils.isEmpty((CharSequence)wxCode)) {
            map.put("errMsg", "wxCode can not be empty.");
            return map;
        }
        Example example = new Example(WechatEnterpriseApp.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("wxCode", wxCode);
        List wechatEnterpriseApps = this.appMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(wechatEnterpriseApps)) {
            map.put("errMsg", "account can not be found.");
            return map;
        }
        if (wechatEnterpriseApps.size() > 1) {
            map.put("errMsg", "account is not specified.");
            return map;
        }
        try {
            clientUrl = URLDecoder.decode(clientUrl, this.ENCRYPT_TYPE);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("url decoded failed.", (Throwable)e);
            map.put("errMsg", "url decoded failed," + e.getMessage());
        }
        WechatEnterpriseApp app = (WechatEnterpriseApp)wechatEnterpriseApps.get(0);
        WechatAccount account = (WechatAccount)this.accountMapper.selectByPrimaryKey(app.getAccountId());
        if (account == null) {
            map.put("errMsg", "internal data error.");
            return map;
        }
        String timestamp = Long.toString(System.currentTimeMillis() / 1000L);
        String nonceStr = UUID.randomUUID().toString();
        String appId = account.getAppId();
        Integer type = account.getAccountType();
        if (type.equals(WechatAccount.CORP)) {
            WxCpService wxCpService = WeChatUtils.initWxCpService(appId, app.getSecret(), Integer.valueOf(app.getAgentId()), this.proxyHost, this.proxyPort);
            try {
                ticket = wxCpService.getJsapiTicket();
            }
            catch (WxErrorException e) {
                logger.error("get ticket failed.", (Throwable)e);
                map.put("errMsg", "get ticket failed." + e.getMessage());
                return map;
            }
        } else if (type.equals(WechatAccount.SERV) || type.equals(WechatAccount.SUBS)) {
            WxMpService wxMpService = WeChatUtils.initWxMpService(appId, account.getSecret(), this.proxyHost, this.proxyPort);
            try {
                ticket = wxMpService.getJsapiTicket();
            }
            catch (WxErrorException e) {
                logger.error("get ticket failed.", (Throwable)e);
                map.put("errMsg", "get ticket failed," + e.getMessage());
                return map;
            }
        } else {
            map.put("errMsg", "internal data error");
            return map;
        }
        String signature = "";
        String string1 = "jsapi_ticket=" + ticket + "&noncestr=" + nonceStr + "&timestamp=" + timestamp + "&url=" + clientUrl;
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(string1.getBytes("UTF-8"));
            signature = WeChatUtils.byteToHex(crypt.digest());
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            logger.error("sign a signature failed.", (Throwable)e);
            map.put("errMsg", "sign a signature failed.");
        }
        map.put("success", true);
        map.put("appId", appId);
        map.put("timestamp", timestamp);
        map.put("jsapi_ticket", ticket);
        map.put("nonceStr", nonceStr);
        map.put("signature", signature);
        map.put("clientUrl", clientUrl);
        return map;
    }
}

