/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import hls.support.core.wechat.service.IWechatUserInfoService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/r/api", "/"})
public class WechatUserInfoController
extends BaseController {
    @Autowired
    private IWechatUserInfoService service;

    @RequestMapping(value={"/wechat/user/get"})
    @ResponseBody
    public Map<String, Object> getUser(@RequestParam(value="code") String code, @RequestParam(value="wxCode") String wxCode, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.getUserInfo(code, wxCode, requestCtx);
    }

    @RequestMapping(value={"/wechat/userId/openId"})
    @ResponseBody
    public Map<String, Object> getOpenId(@RequestParam(value="userId") String userId, @RequestParam(value="wxCode") String wxCode, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.converToOpenId(userId, wxCode, requestCtx);
    }

    @RequestMapping(value={"/wechat/openId/userId"})
    @ResponseBody
    public Map<String, Object> getUserId(@RequestParam(value="openId") String openId, @RequestParam(value="wxCode") String wxCode, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.converToUserId(openId, wxCode, requestCtx);
    }

    @RequestMapping(value={"/wechat/user/getInfo"})
    @ResponseBody
    public Map<String, Object> getUserInfo(@RequestParam(value="userId") String userId, @RequestParam(value="wxCode") String wxCode, HttpServletRequest request) {
        return this.service.getById(userId, wxCode);
    }
}

