/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.formbean.TemplateMessage;
import hls.support.core.wechat.formbean.WxMessageBean;
import hls.support.core.wechat.service.IWechatMessageService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/r/api", "/"})
public class WechatMessageController
extends BaseController {
    @Autowired
    IWechatMessageService service;
    @Value(value="#{configProperties['file.upload.dir']}")
    private String uploadDir;
    private static Logger logger = LoggerFactory.getLogger(WechatMessageController.class);

    @RequestMapping(value={"/wechat/kefuMessage/send"})
    @ResponseBody
    public ResponseData sendKefuMessage(@RequestBody WxMessageBean messageBean, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.sendKefuMessage(requestCtx, messageBean);
    }

    @RequestMapping(value={"/wechat/templateMsg/getAllTemplate"})
    @ResponseBody
    public ResponseData getAllTemplate(@RequestBody TemplateMessage templateMessage, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.getAllTemplate(requestCtx, templateMessage);
    }

    @RequestMapping(value={"/wechat/templateMsg/delTemplate"})
    @ResponseBody
    public ResponseData deleteTemplate(@RequestBody TemplateMessage templateMessage, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.delTemplate(requestCtx, templateMessage);
    }

    @RequestMapping(value={"/wechat/templateMsg/getIndustry"})
    @ResponseBody
    public ResponseData getIndustry(@RequestBody TemplateMessage templateMessage, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.getIndustry(requestCtx, templateMessage);
    }

    @RequestMapping(value={"/wechat/templateMsg/setIndustry"})
    @ResponseBody
    public ResponseData setIndustry(@RequestBody TemplateMessage templateMessage, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.setIndustry(requestCtx, templateMessage);
    }

    @RequestMapping(value={"/wechat/templateMsg/addTemplate"})
    @ResponseBody
    public ResponseData addTemplate(@RequestBody TemplateMessage templateMessage, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.addTemplate(requestCtx, templateMessage);
    }

    @RequestMapping(value={"/wechat/templateMsg/send"})
    @ResponseBody
    public ResponseData sendTemplateMsg(@RequestBody TemplateMessage templateMessage, @RequestParam(value="accountId") String accountId, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        templateMessage.setAccountId(Long.parseLong(accountId));
        return this.service.sendTemplateMsg(requestCtx, templateMessage);
    }

    @RequestMapping(value={"/wechat/message/send/MPNews"})
    @ResponseBody
    public ResponseData sendMPNews(@RequestBody WxMessageBean messageBean, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return this.service.sendMPNews(requestContext, messageBean);
    }

    @RequestMapping(value={"/wechat/message/send/text"})
    @ResponseBody
    public ResponseData sendText(@RequestBody WxMessageBean messageBean, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return this.service.sendText(requestContext, messageBean);
    }

    @RequestMapping(value={"/wechat/message/send/image"})
    @ResponseBody
    public ResponseData sendImage(@RequestBody WxMessageBean messageBean, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return this.service.sendImage(requestContext, messageBean);
    }

    @RequestMapping(value={"/wechat/message/upload/thumbPicture"})
    @ResponseBody
    public JSONObject uploadThumbPicture(@RequestParam(value="file") MultipartFile image, @RequestParam(value="accountId") Long accountId, HttpServletRequest request) {
        if (image.isEmpty()) {
            return null;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.uploadThumbPicture(requestCtx, image, accountId);
    }

    @RequestMapping(value={"/wechat/message/upload/picture"})
    @ResponseBody
    public String uploadPicture(@RequestParam(value="file") MultipartFile image, HttpServletRequest request) {
        if (image.isEmpty()) {
            return null;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.uploadPicture(requestCtx, image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/wechat/message/download"})
    public void downloadFile(String fileName, HttpServletResponse response) {
        block4: {
            block5: {
                block6: {
                    if (!StringUtils.isNotEmpty((CharSequence)fileName)) break block5;
                    String realPath = this.uploadDir + fileName;
                    File file = new File(realPath);
                    if (!file.exists()) break block6;
                    response.setContentType("application/octet-stream");
                    response.addHeader("Content-Disposition", "attachment;fileName=" + fileName);
                    response.setContentLength((int)FileUtils.sizeOf((File)file));
                    FileInputStream is = null;
                    ServletOutputStream os = null;
                    try {
                        is = new FileInputStream(file);
                        os = response.getOutputStream();
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    catch (Exception e) {
                        try {
                            logger.error("io transformation failed when download file.", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(is);
                            IOUtils.closeQuietly(os);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)is);
                        IOUtils.closeQuietly((OutputStream)os);
                        break block4;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    IOUtils.closeQuietly((OutputStream)os);
                    break block4;
                }
                response.setStatus(204);
                break block4;
            }
            response.setStatus(204);
        }
    }

    @RequestMapping(value={"/r/api/wechat/message/sendMass"})
    @ResponseBody
    public ResponseData sendMass(HttpServletRequest request, @RequestBody Map<String, Object> map) {
        String content = (String)map.get("content");
        IRequest iRequest = this.createRequestContext(request);
        if (!map.containsKey("receivers")) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage("\u672a\u5305\u542b\u53c2\u6570receivers.");
            return responseData;
        }
        List list = (List)map.get("receivers");
        for (Map map1 : list) {
            WxMessageBean messageBean = new WxMessageBean();
            messageBean.setWxCode((String)map1.get("wxCode"));
            messageBean.setTagId((String)map1.get("tagId"));
            messageBean.setTagIds((String)map1.get("corpTagIds"));
            messageBean.setUserIds((String)map1.get("userIds"));
            messageBean.setOpenIds((String)map1.get("openIds"));
            messageBean.setText(content);
            ResponseData responseData = this.service.sendText(iRequest, messageBean);
            if (responseData.isSuccess()) continue;
            return responseData;
        }
        return new ResponseData();
    }
}

