/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.service.IWechatEnterpriseAppService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WechatEnterpriseAppController
extends BaseController {
    @Autowired
    private IWechatEnterpriseAppService service;

    @RequestMapping(value={"/wechat/enterprise/app/query"})
    @ResponseBody
    public ResponseData query(WechatEnterpriseApp dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/wechat/enterprise/app/queryAccount"})
    @ResponseBody
    public ResponseData queryAccount(WechatEnterpriseApp dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest iRequest = this.createRequestContext(request);
        ResponseData responseData = new ResponseData();
        responseData.setRows(this.service.selectApps(iRequest, dto, page, pageSize));
        return responseData;
    }

    @RequestMapping(value={"/wechat/enterprise/app/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<WechatEnterpriseApp> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/wechat/enterprise/app/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<WechatEnterpriseApp> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/wechat/app/queryAccount"})
    @ResponseBody
    public ResponseData queryAccount(WechatEnterpriseApp dto, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.queryAccount(requestCtx, dto);
    }
}

