/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.WechatDepartment;
import hls.support.core.wechat.service.IWechatDepartmentService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/wechat/department"})
public class WechatDepartmentController
extends BaseController {
    @Autowired
    private IWechatDepartmentService service;

    @RequestMapping(value={"/query"})
    @ResponseBody
    public ResponseData query(WechatDepartment dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<WechatDepartment> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.batchUpdateDepartment(requestCtx, dto);
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<WechatDepartment> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/refresh"})
    @ResponseBody
    public ResponseData refresh(HttpServletRequest request, Long accountId) {
        IRequest reusetContext = this.createRequestContext(request);
        return this.service.refresh(reusetContext, accountId);
    }

    @RequestMapping(value={"/queryDepartment"})
    @ResponseBody
    public ResponseData queryDepartment(HttpServletRequest request, WechatDepartment wechatDepartment, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.queryDepartment(requestContext, wechatDepartment, page, pageSize));
    }

    @RequestMapping(value={"/treeListDeapartmentQuery"})
    @ResponseBody
    public ResponseData treeListDeapartmentQuery(HttpServletRequest request, WechatDepartment wechatDepartment) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.treeListDeapartmentQuery(requestContext, wechatDepartment));
    }
}

