/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import hls.support.core.wechat.service.WechatAcceptAutoRecoverService;
import hls.support.core.wechat.utils.WechatCheckUtil;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WechatAcceptAutoRecoverController
extends BaseController {
    private static Logger log = Logger.getLogger(WechatAcceptAutoRecoverController.class);
    @Autowired
    private WechatAcceptAutoRecoverService service;
    @Value(value="#{configProperties['wx.token']}")
    private String token;

    @RequestMapping(value={"/accept/wechat/auto/app"})
    @ResponseBody
    public void wechatService(PrintWriter out, HttpServletResponse response, HttpServletRequest request, @RequestParam(value="signature", required=false) String signature, @RequestParam String timestamp, @RequestParam String nonce, @RequestParam(required=false) String echostr) {
        IRequest iRequest = this.createRequestContext(request);
        log.info((Object)("signature\uff1a" + signature + "\ntimestamp\uff1a" + timestamp + "\nnonce\uff1a" + nonce + "\nechostr\uff1a" + echostr));
        if (StringUtils.isNotEmpty((CharSequence)echostr)) {
            if (WechatCheckUtil.checkSignature(this.token, signature, timestamp, nonce)) {
                log.info((Object)echostr);
                out.print(echostr);
            }
        } else {
            this.service.filterSubscribe(request, response, iRequest);
        }
    }
}

