/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.SubButton;
import hls.support.core.wechat.service.ISubButtonService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sub/button"})
public class SubButtonController
extends BaseController {
    @Autowired
    private ISubButtonService service;

    @RequestMapping(value={"/query"})
    @ResponseBody
    public ResponseData query(SubButton dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<SubButton> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<SubButton> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/queryAll"})
    @ResponseBody
    public ResponseData queryAll(HttpServletRequest request, SubButton subButton) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.queryAll(requestContext, subButton));
    }

    @RequestMapping(value={"/updateMenu"})
    @ResponseBody
    public ResponseData updateMenu(HttpServletRequest request, @RequestBody List<SubButton> subButtons) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.updateMenu(requestContext, subButtons));
    }

    @RequestMapping(value={"/deleteMenu"})
    @ResponseBody
    public ResponseData deleteMenu(HttpServletRequest request, @RequestBody SubButton subButton) {
        IRequest requestContext = this.createRequestContext(request);
        this.service.deleteMenu(requestContext, subButton);
        return new ResponseData();
    }

    @RequestMapping(value={"/push"})
    @ResponseBody
    public ResponseData push(Long wechatId) {
        return this.service.pushMenu(wechatId);
    }
}

