/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.MemberAdditionalInfo;
import hls.support.core.wechat.service.IWechatMemberAdditionalInfoService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MemberAdditionalInfoController
extends BaseController {
    @Autowired
    private IWechatMemberAdditionalInfoService service;

    @RequestMapping(value={"/wechat/member/additional/info/query"})
    @ResponseBody
    public ResponseData query(MemberAdditionalInfo dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/wechat/member/additional/info/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<MemberAdditionalInfo> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/wechat/member/additional/info/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<MemberAdditionalInfo> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }
}

