/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.EnterpriseAppDepartment;
import hls.support.core.wechat.dto.WechatDepartment;
import hls.support.core.wechat.service.IAppDepartmentService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AppDepartmentController
extends BaseController {
    @Autowired
    private IAppDepartmentService service;

    @RequestMapping(value={"/enterprise/app/department/query"})
    @ResponseBody
    public ResponseData query(EnterpriseAppDepartment dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/enterprise/app/department/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<EnterpriseAppDepartment> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/enterprise/app/department/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<EnterpriseAppDepartment> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/department/queryByApp"})
    @ResponseBody
    public ResponseData queryByApp(HttpServletRequest request, WechatDepartment wechatDepartment, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.queryByApp(requestContext, wechatDepartment, page, pageSize));
    }
}

