/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.components;

import hls.support.core.wechat.dto.AutoRecover;
import hls.support.core.wechat.service.IAutoRecoverService;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import me.chanjar.weixin.mp.api.WxMpMessageMatcher;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageMatcher
implements WxMpMessageMatcher {
    @Autowired
    private IAutoRecoverService service;
    private static MessageMatcher messageMatcher;
    private static String MATCH_FLAG_TRUE;
    private static String MATCH_FLAG_FALSE;
    private String flag = MATCH_FLAG_FALSE;

    public void setIAutoRecoverService(IAutoRecoverService service) {
        this.service = service;
    }

    @PostConstruct
    public void init() {
        messageMatcher = this;
        MessageMatcher.messageMatcher.service = this.service;
    }

    public boolean match(WxMpXmlMessage wxMpXmlMessage) {
        List<AutoRecover> messages = MessageMatcher.messageMatcher.service.queryAll();
        for (AutoRecover message : messages) {
            if (Pattern.matches(".*" + message.getContent() + ".*", wxMpXmlMessage.getContent())) {
                this.flag = MATCH_FLAG_TRUE;
                break;
            }
            this.flag = MATCH_FLAG_FALSE;
        }
        return this.flag == MATCH_FLAG_TRUE;
    }

    static {
        MATCH_FLAG_TRUE = "true";
        MATCH_FLAG_FALSE = "false";
    }
}

