/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.sys.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.ISysConfigService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.sys.dto.SysCustMasterData;
import hls.support.core.sys.mapper.SysCustMasterDataMapper;
import hls.support.core.sys.service.ISysCustMasterDataService;
import hls.support.core.sys.utils.SysCustDataSql;
import hls.support.core.wechat.service.impl.AcceptWechatNoticeImpl;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysCustMasterDataServiceImpl
extends BaseServiceImpl<SysCustMasterData>
implements ISysCustMasterDataService {
    @Autowired
    private ISysConfigService sysConfigService;
    @Autowired
    private SysCustMasterDataMapper sysCustMasterDataMapper;
    private static Logger logger = Logger.getLogger(AcceptWechatNoticeImpl.class);

    @Override
    public ResponseData addOrUpdate(IRequest requestCtx, List<SysCustMasterData> dtoList) {
        ArrayList<SysCustMasterData> updateList = new ArrayList<SysCustMasterData>();
        for (SysCustMasterData dto : dtoList) {
            List<SysCustMasterData> curList = this.sysCustMasterDataMapper.queryInfoByBpId(dto);
            if (curList.size() > 0) {
                dto.set__status("update");
                dto.setCustId(curList.get(0).getCustId());
            } else {
                dto.set__status("add");
            }
            updateList.add(dto);
        }
        return new ResponseData(((ISysCustMasterDataService)this.self()).batchUpdate(requestCtx, updateList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void SynCustMasterData() {
        PreparedStatement statementChk = null;
        ResultSet resChk = null;
        Statement statement = null;
        ResultSet res = null;
        Connection conn = null;
        try {
            String custEtlDate;
            Long custDataSize;
            Class.forName("oracle.jdbc.driver.OracleDriver");
            conn = DriverManager.getConnection(this.sysConfigService.getConfigValue("BI_DB_URL"), this.sysConfigService.getConfigValue("BI_DB_USER"), this.sysConfigService.getConfigValue("BI_DB_PASSWORD"));
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(8);
            statementChk = conn.prepareStatement(SysCustDataSql.fpSql);
            resChk = statementChk.executeQuery();
            resChk.next();
            if (resChk.getString("FLAG").equals("1") && (custDataSize = this.sysCustMasterDataMapper.queryInfoSize(custEtlDate = resChk.getString("ETL_DATE"))) == 0L) {
                statementChk.close();
                resChk.close();
                statement = conn.prepareStatement(SysCustDataSql.dataSql);
                statement.setString(1, custEtlDate);
                statement.setString(2, custEtlDate);
                statement.setString(3, custEtlDate);
                statement.setString(4, custEtlDate);
                res = statement.executeQuery();
                this.saveCustData(res);
            }
            conn.close();
        }
        catch (Exception e) {
            e.getMessage();
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    private boolean saveCustData(ResultSet res) {
        boolean rtnFlag = false;
        try {
            while (res.next()) {
                SysCustMasterData dto = new SysCustMasterData();
                dto.setBpId(res.getString("bpId"));
                dto.setCustCard(res.getString("custCard"));
                dto.setCustMail(res.getString("custMail"));
                dto.setCustName(res.getString("custName"));
                dto.setCustOpenId(res.getString("custOpenId"));
                dto.setCustPhone(res.getString("custPhone"));
                dto.setCustConNumber(res.getString("conNum"));
                dto.setCustEtlDate(res.getString("etlDate"));
                dto.setCustRole(res.getString("custRole"));
                dto.set__status("add");
                this.sysCustMasterDataMapper.insertSelective(dto);
            }
            rtnFlag = true;
        }
        catch (Exception e) {
            rtnFlag = false;
            e.getMessage();
        }
        return rtnFlag;
    }
}

