/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.sys.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.sys.bean.CommonMessageBean;
import hls.support.core.sys.dto.SysChannelManage;
import hls.support.core.sys.dto.SysChannelNotice;
import hls.support.core.sys.dto.SysChannelPassManage;
import hls.support.core.sys.mapper.SysChannelManageMapper;
import hls.support.core.sys.mapper.SysChannelNoticeMapper;
import hls.support.core.sys.mapper.SysChannelPassManageMapper;
import hls.support.core.sys.service.ISysChannelManageService;
import hls.support.core.sys.service.ISysChannelSendService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class SysChannelManageServiceImpl
extends BaseServiceImpl<SysChannelManage>
implements ISysChannelManageService,
ApplicationContextAware {
    @Autowired
    private SysChannelManageMapper sysChannelManageMapper;
    @Autowired
    private SysChannelPassManageMapper sysChannelPassManageMapper;
    private Map<String, ISysChannelSendService> sysChannelSendServiceMap;
    @Autowired
    private SysChannelNoticeMapper sysChannelNoticeMapper;
    @Value(value="#{configProperties['thread.taskSize']}")
    private String thredTaskSize;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List sendMsgByChannel(IRequest requestContext, List<CommonMessageBean> dtoList) throws ExecutionException, InterruptedException {
        ArrayList rtnList = new ArrayList();
        this.logger.debug("*******\u5f00\u59cb\u591a\u7ebf\u7a0b\u5e76\u53d1*********");
        Date startDate = new Date();
        int taskSize = Integer.parseInt(this.thredTaskSize);
        int taskDoCount = dtoList.size() % taskSize == 0 ? dtoList.size() / taskSize : dtoList.size() / taskSize + 1;
        ExecutorService pool = Executors.newFixedThreadPool(taskSize);
        ArrayList<Future<List>> list = new ArrayList<Future<List>>();
        if (taskSize < dtoList.size()) {
            for (int i = 0; i < taskSize; ++i) {
                int n = i * taskDoCount;
                int endIndex = 0;
                endIndex = i * taskDoCount < dtoList.size() ? (i + 1) * taskDoCount : dtoList.size() - 1;
                List<CommonMessageBean> param = dtoList.subList(n, endIndex);
                MyCallable c = new MyCallable(requestContext, param);
                Future<List> f = pool.submit(c);
                list.add(f);
            }
        } else {
            MyCallable c = new MyCallable(requestContext, dtoList);
            Future<List> future = pool.submit(c);
            list.add(future);
        }
        pool.shutdown();
        try {
            for (Future future : list) {
                for (List obj : Arrays.asList((List)future.get())) {
                    for (int p = 0; p < ((ArrayList)obj).size(); ++p) {
                        rtnList.add(((ArrayList)obj).get(p));
                    }
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Date endDate = new Date();
        this.logger.debug("*****\u591a\u7ebf\u7a0b\u8fd0\u884c\u7ed3\u675f*****\uff0c\u603b\u53d1\u9001\u65f6\u95f4\u4e3a\uff1a\u3010" + (endDate.getTime() - startDate.getTime()) + "\u6beb\u79d2\u3011");
        return rtnList;
    }

    private Map foreachList(IRequest requestContext, CommonMessageBean messageBean) {
        ResponseData responseData = new ResponseData();
        Map<String, String> rtMap = new HashMap<String, String>();
        List<SysChannelManage> dtoList = this.sysChannelManageMapper.queryChannelByType(messageBean.getSendMsgType());
        if (dtoList.get(0).getBlacklist() != null && !"".equals(dtoList.get(0).getBlacklist())) {
            messageBean = this.checkBlackList(messageBean, dtoList.get(0).getBlacklist());
        }
        if (CollectionUtils.isNotEmpty(dtoList) && dtoList.get(0).getEnableFlag().equals("Y")) {
            SysChannelManage channelManage = dtoList.get(0);
            for (int i = 0; i < channelManage.getDoStr().split(",").length; ++i) {
                rtMap = this.orderSend(requestContext, messageBean, channelManage.getDoStr().split(",")[i]);
                if (!responseData.isSuccess()) {
                    this.logger.warn("unknown error !");
                    rtMap.put("message", "\u5b9e\u73b0\u7c7b\u9519\u8bef\u6216\u6d88\u606f\u7c7b\u578b\u6ca1\u6709\u542f\u7528");
                    rtMap.put("success", "false");
                    continue;
                }
                break;
            }
        } else {
            this.logger.warn("channel is not found or enable is false !");
            rtMap.put("documentNumber", messageBean.getDocumentNumber());
            rtMap.put("batchid", "");
            rtMap.put("toChannel", "");
            rtMap.put("fromChannel", messageBean.getFromChannel());
            rtMap.put("message", "\u6e20\u9053\u7ba1\u7406\u65b9\u5f0f\u4e0d\u5b58\u5728\u6216\u8005\u6e20\u9053\u7ba1\u7406\u65b9\u5f0f\u672a\u542f\u7528");
            rtMap.put("success", "false");
        }
        return rtMap;
    }

    private Map orderSend(IRequest requestContext, CommonMessageBean dto, String type) {
        HashMap<String, Object> rtMap = new HashMap<String, Object>();
        List<SysChannelPassManage> channelList = this.sysChannelPassManageMapper.queryPassByValue(type);
        if (channelList.size() > 0 && channelList.get(0).getEnableFlag().equals("Y")) {
            ISysChannelSendService sysChannelSendService;
            SysChannelPassManage channel = channelList.get(0);
            if (channel.getPassValue().equals("sms")) {
                Float ltPb = channel.getLtPb();
                Float xwPb = channel.getXwPb();
                if (ltPb == null && xwPb == null) {
                    rtMap.put("message", "\u8bf7\u914d\u7f6e\u77ed\u4fe1\u7684\u53d1\u9001\u5206\u914d\u7387");
                    return rtMap;
                }
                sysChannelSendService = this.randomSmsSend(ltPb);
            } else {
                sysChannelSendService = this.sysChannelSendServiceMap.get(channel.getPassClass());
            }
            try {
                ResponseData responseData = sysChannelSendService.sendMsg(requestContext, dto);
                if (responseData.isSuccess()) {
                    rtMap.put("message", "\u53d1\u9001\u6210\u529f");
                    rtMap.put("success", "true");
                } else {
                    rtMap.put("message", responseData.getMessage());
                    rtMap.put("success", responseData.isSuccess());
                }
                rtMap.put("batchid", responseData.getCode());
            }
            catch (Exception e) {
                this.logger.warn(e.getMessage());
                rtMap.put("batchid", "");
                rtMap.put("success", "false");
                rtMap.put("message", "\u53d1\u9001\u6d88\u606f\u5b9e\u73b0\u7c7b\u5b58\u5728\u95ee\u9898");
            }
        } else {
            this.logger.warn("noticeType is not found or enable is false !");
            rtMap.put("batchid", "");
            rtMap.put("success", "false");
            rtMap.put("message", "\u4e0d\u5b58\u5728\u6d88\u606f\u7c7b\u578b\u6216\u8005\u6d88\u606f\u7c7b\u578b\u6ca1\u6709\u542f\u7528");
        }
        rtMap.put("toChannel", type);
        rtMap.put("fromChannel", dto.getFromChannel() != null ? dto.getFromChannel() : "");
        rtMap.put("documentNumber", dto.getDocumentNumber());
        if (dto != null) {
            if (this.saveChannelNotice(requestContext, dto, type, rtMap)) {
                this.logger.debug("\u6d88\u606f\u4fdd\u5b58\u6210\u529f");
            } else {
                this.logger.debug("\u6d88\u606f\u4fdd\u5b58\u5931\u8d25");
            }
        }
        return rtMap;
    }

    @Override
    public List<SysChannelManage> update(IRequest requestContext, List<SysChannelManage> list) {
        if (list.size() > 0) {
            for (SysChannelManage dto : list) {
                this.sysChannelManageMapper.updateByPrimaryKey(dto);
            }
        }
        return this.sysChannelManageMapper.selectAll();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beansOfType = applicationContext.getBeansOfType(ISysChannelSendService.class);
        this.sysChannelSendServiceMap = new HashMap<String, ISysChannelSendService>(beansOfType.size());
        beansOfType.forEach((k, v) -> this.sysChannelSendServiceMap.put(v.getCode(), (ISysChannelSendService)v));
    }

    private ISysChannelSendService randomSmsSend(Float ltPb) {
        int num = (int)(Math.random() * 100.0);
        if (num >= 0 && (float)num < ltPb.floatValue() * 100.0f) {
            return this.sysChannelSendServiceMap.get("hls.support.core.sys.service.impl.SmsSendServiceImpl");
        }
        return this.sysChannelSendServiceMap.get("hls.support.core.sys.service.impl.XwSmsSendServiceImpl");
    }

    private CommonMessageBean checkBlackList(CommonMessageBean dto, String blackList) {
        String[] rmBlackLsit = blackList.split(",|\uff0c|\uff1b|;|\u3001|/|[\t \n]+| +| ");
        ArrayList<String> black = new ArrayList<String>(Arrays.asList(rmBlackLsit));
        String phoneStr = "";
        String mailStr = "";
        String wechatStr = "";
        if (dto.getEmailParams().get("receivers") != null && !"".equals(dto.getEmailParams().get("receivers"))) {
            String[] mailList = dto.getEmailParams().get("receivers").toString().split(",|\uff0c|\uff1b|;|\u3001|/|[\t \n]+| +| ");
            ArrayList<String> rmMailList = new ArrayList<String>(Arrays.asList(mailList));
            for (String blackStr : black) {
                if (!rmMailList.contains(blackStr)) continue;
                rmMailList.remove(blackStr);
            }
            mailStr = ((Object)rmMailList).toString().replace("[", "").replace("]", "");
        }
        if (dto.getWxMessageBean().getOpenId() != null && !"".equals(dto.getWxMessageBean().getOpenId())) {
            String[] wxList = dto.getWxMessageBean().getOpenId().split(",|\uff0c|\uff1b|;|\u3001|/|[\t \n]+| +| ");
            ArrayList<String> rmWxList = new ArrayList<String>(Arrays.asList(wxList));
            for (String blackStr : black) {
                if (!rmWxList.contains(blackStr)) continue;
                rmWxList.remove(blackStr);
            }
            wechatStr = ((Object)rmWxList).toString().replace("[", "").replace("]", "");
        }
        dto.getEmailParams().put("receivers", mailStr);
        dto.getWxMessageBean().setOpenId(wechatStr);
        return null;
    }

    private boolean saveChannelNotice(IRequest requestContext, CommonMessageBean dto, String type, Map map) {
        boolean rtnFlag = false;
        SysChannelNotice sysChannelNotice = new SysChannelNotice();
        sysChannelNotice.setBpId(dto.getBp_id());
        sysChannelNotice.setContent(dto.getContent());
        sysChannelNotice.setSendMsgType(dto.getSendMsgType());
        sysChannelNotice.setFromChannel(dto.getFromChannel());
        sysChannelNotice.setMessageType(dto.getMessageType());
        sysChannelNotice.setToChannel(type);
        sysChannelNotice.setDocNum(dto.getDocumentNumber());
        sysChannelNotice.setSendSuccess(map.get("success") != null ? map.get("success").toString() : "");
        sysChannelNotice.setReturnMessage(map.get("message") != null ? map.get("message").toString() : "");
        sysChannelNotice.setOpenId(dto.getWxMessageBean() != null ? dto.getWxMessageBean().getOpenId() : "");
        sysChannelNotice.setTemplateId(dto.getWxMessageBean() != null ? dto.getWxMessageBean().getTemplateId() : "");
        sysChannelNotice.setReceivers(dto.getEmailParams().get("receivers") != null ? dto.getEmailParams().get("receivers").toString() : "");
        sysChannelNotice.setSubject(dto.getEmailParams().get("subject") != null ? dto.getEmailParams().get("subject").toString() : "");
        int flag = 0;
        try {
            flag = this.sysChannelNoticeMapper.insertSelective(sysChannelNotice);
        }
        catch (Exception e) {
            flag = -1;
            this.logger.debug(e.getMessage());
        }
        rtnFlag = flag > 0;
        return rtnFlag;
    }

    private List sendNoticeList(IRequest iRequest, List dtoList) {
        ArrayList<Map> list = new ArrayList<Map>();
        int j = 0;
        for (int i = 0; i < dtoList.size(); ++i) {
            System.out.println("******************\u5f53\u524d\u4e0b\u6807\uff1a" + ++j);
            if (((CommonMessageBean)dtoList.get(i)).getSendMsgType().equals("USER_DEFINED_SEND")) {
                System.out.println("******************\u6211\u8d70\u4e86\u4e0a\u9762\u7684if\uff1a" + ((CommonMessageBean)dtoList.get(i)).getContent());
                list.add(this.orderSend(iRequest, (CommonMessageBean)dtoList.get(i), ((CommonMessageBean)dtoList.get(i)).getMessageType()));
                continue;
            }
            System.out.println("******************\u6211\u8d70\u4e86\u4e0b\u9762\u7684else\uff1a" + ((CommonMessageBean)dtoList.get(i)).getContent());
            list.add(this.foreachList(iRequest, (CommonMessageBean)dtoList.get(i)));
        }
        return list;
    }

    class MyCallable
    implements Callable<List> {
        private List dtoList;
        private IRequest iRequest;

        MyCallable(IRequest iRequest, List dtoList) {
            this.dtoList = dtoList;
            this.iRequest = iRequest;
        }

        @Override
        public List call() throws Exception {
            if (CollectionUtils.isNotEmpty((Collection)this.dtoList)) {
                return SysChannelManageServiceImpl.this.sendNoticeList(this.iRequest, this.dtoList);
            }
            ArrayList list = new ArrayList();
            HashMap<String, String> rtMap = new HashMap<String, String>();
            rtMap.put("success", "false");
            rtMap.put("documentNumber", "");
            rtMap.put("batchid", "");
            rtMap.put("toChannel", "");
            rtMap.put("fromChannel", "");
            rtMap.put("message", "\u6ca1\u6709\u63a5\u53d7\u5230\u6570\u636e");
            list.add(rtMap);
            return list;
        }
    }
}

