/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.sys.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.sys.dto.SysCustMasterData;
import hls.support.core.sys.service.ISysCustMasterDataService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SysCustMasterDataController
extends BaseController {
    @Autowired
    private ISysCustMasterDataService sysCustMasterDataService;

    @RequestMapping(value={"/r/api/sync/custom/data", "/sync/custom/data"})
    @ResponseBody
    public ResponseData syncCustData(HttpServletRequest request, @RequestBody List<SysCustMasterData> dtoList, BindingResult result) {
        IRequest requestCtx = this.createRequestContext(request);
        this.getValidator().validate(dtoList, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        this.sysCustMasterDataService.addOrUpdate(requestCtx, dtoList);
        return new ResponseData();
    }

    @RequestMapping(value={"/sys/cust/master/data/query"})
    @ResponseBody
    public ResponseData query(SysCustMasterData dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.sysCustMasterDataService.select(requestContext, dto, page, pageSize));
    }
}

