/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.SysPreferences;
import com.hand.hap.system.mapper.SysPreferencesMapper;
import com.hand.hap.system.service.ISysPreferencesService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysPreferencesServiceImpl
implements ISysPreferencesService {
    private Logger logger = LoggerFactory.getLogger(SysPreferencesServiceImpl.class);
    @Autowired
    private SysPreferencesMapper sysPreferencesMapper;

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public List<SysPreferences> saveSysPreferences(IRequest requestContext, List<SysPreferences> preferences) {
        if (preferences.isEmpty() && this.logger.isDebugEnabled()) {
            this.logger.debug("sysPreferences is null");
        }
        for (SysPreferences sysPreferences : preferences) {
            if (((ISysPreferencesService)this.self()).selectUserPreference(sysPreferences.getPreferences(), sysPreferences.getUserId()) == null) {
                this.sysPreferencesMapper.insertSelective(sysPreferences);
                continue;
            }
            this.sysPreferencesMapper.updatePreferLine(sysPreferences);
        }
        return preferences;
    }

    @Override
    public List<SysPreferences> querySysPreferences(IRequest requestContext, SysPreferences preferences) {
        return this.sysPreferencesMapper.select(preferences);
    }

    @Override
    public SysPreferences selectUserPreference(String preference, Long userId) {
        SysPreferences p = new SysPreferences();
        p.setPreferences(preference);
        p.setUserId(userId);
        return this.sysPreferencesMapper.selectUserPreference(p);
    }
}

