/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.hand.hap.cache.impl.LovCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.IRequestAware;
import com.hand.hap.mybatis.util.SqlMapper;
import com.hand.hap.system.dto.DTOClassInfo;
import com.hand.hap.system.dto.Lov;
import com.hand.hap.system.dto.LovItem;
import com.hand.hap.system.mapper.LovItemMapper;
import com.hand.hap.system.mapper.LovMapper;
import com.hand.hap.system.service.ILovService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LovServiceImpl
extends BaseServiceImpl<Lov>
implements ILovService {
    private final Logger logger = LoggerFactory.getLogger(LovServiceImpl.class);
    @Autowired
    @Qualifier(value="sqlSessionFactory")
    private SqlSessionFactory sqlSessionFactory;
    @Autowired
    private BeanFactory beanFactory;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private LovMapper lovMapper;
    @Autowired
    private LovItemMapper lovItemMapper;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private LovCache lovCache;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<Lov> selectLovs(IRequest request, Lov lov, int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        List<Lov> lovs = this.lovMapper.selectLovs(lov);
        return lovs;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public Lov loadLov(Long lovId) {
        return (Lov)this.lovMapper.selectByPrimaryKey(lovId);
    }

    @Override
    public List<Lov> batchUpdate(IRequest request, List<Lov> lovs) {
        for (Lov lov : lovs) {
            if (lov.getLovId() == null) {
                ((ILovService)this.self()).createLov(lov);
                continue;
            }
            if (lov.getLovId() == null) continue;
            ((ILovService)this.self()).updateLov(lov);
        }
        return lovs;
    }

    @Override
    public boolean batchDeleteLov(List<Lov> items) {
        for (Lov lov : items) {
            int updateCount = this.lovMapper.deleteByPrimaryKey(lov);
            this.checkOvn(updateCount, lov);
            this.lovItemMapper.deleteByLovId(lov.getLovId());
            this.lovCache.remove(lov.getCode());
        }
        return true;
    }

    @Override
    public boolean batchDeleteItems(List<LovItem> items) {
        for (LovItem item : items) {
            ((ILovService)this.self()).deleteLovItem(item);
        }
        return true;
    }

    @Override
    public boolean deleteLovItem(LovItem item) {
        int updateCount = this.lovItemMapper.deleteByPrimaryKey(item);
        this.checkOvn(updateCount, item);
        if (1 == updateCount) {
            this.lovCache.reload(item.getLovId());
            return true;
        }
        return false;
    }

    @Override
    public Lov createLov(Lov lov) {
        this.lovMapper.insertSelective(lov);
        if (lov.getLovItems() != null) {
            for (LovItem lovItem : lov.getLovItems()) {
                lovItem.setLovId(lov.getLovId());
                this.lovItemMapper.insertSelective(lovItem);
            }
        }
        this.lovCache.reload(lov.getLovId());
        return lov;
    }

    @Override
    public Lov updateLov(Lov lov) {
        int updateCount = this.lovMapper.updateByPrimaryKeySelective(lov);
        this.checkOvn(updateCount, lov);
        if (lov.getLovItems() != null) {
            for (LovItem lovItem : lov.getLovItems()) {
                if (lovItem.getLovItemId() == null) {
                    lovItem.setLovId(lov.getLovId());
                    this.lovItemMapper.insertSelective(lovItem);
                    continue;
                }
                this.lovItemMapper.updateByPrimaryKeySelective(lovItem);
            }
        }
        this.lovCache.reload(lov.getLovId());
        return lov;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<LovItem> selectLovItems(IRequest request, LovItem lovItem) {
        return this.lovItemMapper.selectByLovId(lovItem.getLovId());
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public String getLov(String contextPath, Locale locale, String lovCode) {
        LovEditor editor = this.getLovEditor(contextPath, locale, lovCode);
        try {
            return this.objectMapper.writeValueAsString((Object)editor);
        }
        catch (JsonProcessingException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            return "''";
        }
    }

    private LovEditor getLovEditor(String contextPath, Locale locale, String lovCode) {
        Lov lov = this.lovCache.getValue(lovCode);
        if (lov == null && (lov = this.lovMapper.selectByCode(lovCode)) != null) {
            List<LovItem> items = this.lovItemMapper.selectByLovId(lov.getLovId());
            lov.setLovItems(items);
            this.lovCache.setValue(lov.getCode(), lov);
        }
        return lov != null ? this.createLovEditor(contextPath, locale, lov, lov.getLovItems()) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<?> selectDatas(IRequest request, String code, Object obj, int page, int pagesize) {
        int n;
        Class<?>[] classArray;
        String beanName;
        Lov lov = this.lovCache.getValue(code);
        String sqlId = lov.getSqlId();
        String customSql = lov.getCustomSql();
        String customUrl = lov.getCustomUrl();
        if (StringUtils.isNotEmpty((String)sqlId)) {
            Class<?>[] interfaceClass;
            beanName = StringUtils.uncapitalize((String)StringUtils.substringBefore((String)lov.getSqlId(), (String)"."));
            Object mapperObjectDelegate = this.beanFactory.getBean(beanName);
            if (mapperObjectDelegate == null) {
                return Collections.emptyList();
            }
            classArray = interfaceClass = mapperObjectDelegate.getClass().getInterfaces();
            n = classArray.length;
        } else {
            if (!StringUtils.isNotEmpty((String)customSql)) return Collections.emptyList();
            try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
                PageHelper.startPage(page, pagesize);
                SqlMapper sqlMapper = new SqlMapper(sqlSession);
                if (obj instanceof Map) {
                    ((Map)obj).put("request", request);
                }
                List<HashMap> preResults = sqlMapper.selectList("<script>\n\t" + customSql + "</script>", obj, HashMap.class);
                Page results = new Page();
                results.setTotal(((Page)preResults).getTotal());
                for (HashMap m0 : preResults) {
                    HashMap map = new HashMap();
                    m0.forEach((k, v) -> map.put(DTOClassInfo.underLineToCamel((String)k), v));
                    results.add(map);
                }
                Page page2 = results;
                return page2;
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) return Collections.emptyList();
                this.logger.error(e.getMessage(), e);
            }
            return Collections.emptyList();
        }
        for (int i = 0; i < n; ++i) {
            Class<?> c = classArray[i];
            if (!c.getSimpleName().equalsIgnoreCase(beanName)) continue;
            sqlId = c.getPackage().getName() + "." + StringUtils.capitalize((String)lov.getSqlId());
            break;
        }
        try (SqlSession sqlSession2 = this.sqlSessionFactory.openSession();){
            PageHelper.startPage(page, pagesize);
            obj = this.convertMapParamToDtoParam(sqlSession2, sqlId, obj);
            if (obj instanceof IRequestAware) {
                ((IRequestAware)obj).setRequest(request);
            } else if (obj instanceof Map) {
                ((Map)obj).put("request", request);
            }
            List list = sqlSession2.selectList(sqlId, obj);
            return list;
        }
        catch (Throwable e) {
            if (!this.logger.isErrorEnabled()) return Collections.emptyList();
            this.logger.error(e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    private Object convertMapParamToDtoParam(SqlSession sqlSession, String sqlId, Object map) {
        if (!(map instanceof Map)) {
            this.logger.warn("lov query parameter is not a map:{}", map);
            return map;
        }
        MappedStatement statement = sqlSession.getConfiguration().getMappedStatement(sqlId);
        if (statement == null) {
            this.logger.warn("no statement found for sqlId:{}", (Object)sqlId);
            return map;
        }
        List resultMaps = statement.getResultMaps();
        if (resultMaps == null || resultMaps.isEmpty()) {
            this.logger.warn("statement has no specified ResultMap, sqlId:{}", (Object)sqlId);
            return map;
        }
        ResultMap resultMap = (ResultMap)resultMaps.get(0);
        try {
            Class dtoClass = resultMap.getType();
            Object dto = dtoClass.newInstance();
            if (dto instanceof Map) {
                return map;
            }
            ((Map)map).forEach((k, v) -> {
                try {
                    PropertyDescriptor desc = PropertyUtils.getPropertyDescriptor((Object)dto, (String)((String)k));
                    if (desc != null) {
                        BeanUtils.setProperty((Object)dto, (String)((String)k), (Object)v);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            this.logger.debug("convert lov query parameter to {}", dto);
            return dto;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private LovEditor createLovEditor(String contextPath, Locale locale, Lov lov, List<LovItem> items) {
        LovEditor editor = new LovEditor(lov, locale);
        editor.setGrid(new LovGrid(contextPath, locale, lov, items));
        editor.setCondition(new LovCondition(contextPath, locale, lov, items));
        return editor;
    }

    class LovConditionFieldSelectOption {
        private String valueField;
        private String textField;
        private String url;

        LovConditionFieldSelectOption(String contextPath, LovItem item) {
            if (item.getConditionFieldSelectCode() != null) {
                this.setUrl(contextPath + "/common/code/" + item.getConditionFieldSelectCode() + "/");
                this.setValueField("value");
                this.setTextField("meaning");
            } else if (item.getConditionFieldSelectUrl() != null) {
                this.setUrl(contextPath + item.getConditionFieldSelectUrl());
                this.setValueField(item.getConditionFieldSelectVf());
                this.setTextField(item.getConditionFieldSelectTf());
            }
        }

        public String getValueField() {
            return this.valueField;
        }

        public void setValueField(String valueField) {
            this.valueField = valueField;
        }

        public String getTextField() {
            return this.textField;
        }

        public void setTextField(String textField) {
            this.textField = textField;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    class LovConditionField
    extends LovGridColumn {
        private String type;
        private boolean newline;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String textField;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Integer width;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Object options;

        LovConditionField(String contextPath, Locale locale, LovItem item) {
            super(contextPath, locale, item);
            this.setName(item.getConditionFieldName() == null ? item.getGridFieldName() : item.getConditionFieldName());
            if (item.getConditionFieldTextfield() != null) {
                this.setTextField(item.getConditionFieldTextfield());
            }
            this.setType(item.getConditionFieldType());
            this.setWidth(item.getConditionFieldWidth());
            this.setNewline("Y".equalsIgnoreCase(item.getConditionFieldNewline()));
            this.setSequence(item.getConditionFieldSequence());
            if (item.getConditionFieldSelectCode() != null || item.getConditionFieldSelectUrl() != null) {
                this.setOptions(new LovConditionFieldSelectOption(contextPath, item));
            } else if (item.getConditionFieldLovCode() != null) {
                LovEditor editor = LovServiceImpl.this.getLovEditor(contextPath, locale, item.getConditionFieldLovCode());
                this.setOptions(editor);
            }
        }

        public String getTextField() {
            return this.textField;
        }

        public void setTextField(String textField) {
            this.textField = textField;
        }

        @Override
        public Integer getWidth() {
            return this.width;
        }

        @Override
        public void setWidth(Integer width) {
            this.width = width;
        }

        public Object getOptions() {
            return this.options;
        }

        public void setOptions(Object options) {
            this.options = options;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean isNewline() {
            return this.newline;
        }

        public void setNewline(boolean newline) {
            this.newline = newline;
        }
    }

    class LovCondition {
        private List<LovConditionField> fields = new ArrayList<LovConditionField>();

        LovCondition(String contextPath, Locale locale, Lov lov, List<LovItem> items) {
            for (LovItem item : items) {
                if (!"Y".equalsIgnoreCase(item.getConditionField())) continue;
                this.addField(new LovConditionField(contextPath, locale, item));
            }
            this.fields.sort((a, b) -> a.getSequence() - b.getSequence());
        }

        public List<LovConditionField> getFields() {
            return this.fields;
        }

        public void setFields(List<LovConditionField> fields) {
            this.fields = fields;
        }

        public void addField(LovConditionField f) {
            this.fields.add(f);
        }
    }

    class LovGridColumn {
        @JsonIgnore
        private Integer sequence = 1;
        private String display;
        private String name;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String align;
        private boolean isSort = false;
        private boolean autocompleteField = false;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Integer width;

        LovGridColumn(String contextPath, Locale locale, LovItem item) {
            String display = LovServiceImpl.this.messageSource.getMessage(item.getDisplay(), null, item.getDisplay(), locale);
            this.setDisplay(display);
            this.setName(item.getGridFieldName());
            this.setSequence(item.getGridFieldSequence());
            this.setAlign(item.getGridFieldAlign());
            this.setWidth(item.getGridFieldWidth());
            this.setAutocompleteField("Y".equals(item.getAutocompleteField()));
        }

        public String getAlign() {
            return this.align;
        }

        public void setAlign(String align) {
            this.align = align;
        }

        public Integer getSequence() {
            return this.sequence;
        }

        public void setSequence(Integer sequence) {
            this.sequence = sequence;
        }

        public boolean getAutocompleteField() {
            return this.autocompleteField;
        }

        public void setAutocompleteField(boolean autocompleteField) {
            this.autocompleteField = autocompleteField;
        }

        public boolean getIsSort() {
            return this.isSort;
        }

        public void setIsSort(boolean isSort) {
            this.isSort = isSort;
        }

        public String getDisplay() {
            return this.display;
        }

        public void setDisplay(String display) {
            this.display = display;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getWidth() {
            return this.width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }
    }

    class LovGrid {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Integer width;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Integer height;
        private boolean delayLoad = false;
        private boolean needQueryParam = false;
        private String url;
        private boolean isSingleCheck = true;
        private List<LovGridColumn> columns = new ArrayList<LovGridColumn>();

        LovGrid(String contextPath, Locale locale, Lov lov, List<LovItem> items) {
            this.setUrl(contextPath + "/common/lov/" + lov.getCode());
            this.setWidth(lov.getWidth());
            this.setHeight(lov.getHeight());
            this.setDelayLoad("Y".equalsIgnoreCase(lov.getDelayLoad()));
            this.setNeedQueryParam("Y".equalsIgnoreCase(lov.getNeedQueryParam()));
            if (items != null) {
                for (LovItem item : items) {
                    if (!"Y".equalsIgnoreCase(item.getGridField())) continue;
                    this.addColumn(new LovGridColumn(contextPath, locale, item));
                }
                this.columns.sort((a, b) -> a.getSequence() - b.getSequence());
            }
        }

        public Boolean getNeedQueryParam() {
            return this.needQueryParam;
        }

        public void setNeedQueryParam(boolean needQueryParam) {
            this.needQueryParam = needQueryParam;
        }

        public Boolean getDelayLoad() {
            return this.delayLoad;
        }

        public void setDelayLoad(boolean delayLoad) {
            this.delayLoad = delayLoad;
        }

        public boolean getIsSingleCheck() {
            return this.isSingleCheck;
        }

        public void setIsSingleCheck(boolean isSingleCheck) {
            this.isSingleCheck = isSingleCheck;
        }

        public Integer getWidth() {
            return this.width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public Integer getHeight() {
            return this.height;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void addColumn(LovGridColumn column) {
            this.columns.add(column);
        }

        public List<LovGridColumn> getColumns() {
            return this.columns;
        }

        public void setColumns(List<LovGridColumn> columns) {
            this.columns = columns;
        }
    }

    private class LovEditor {
        private String type = "popup";
        private String valueField;
        private String textField;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String title;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String placeholder;
        private LovGrid grid;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private boolean autocomplete;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Boolean readonly = null;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private boolean popup;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String autocompleteField;
        private LovCondition condition;

        LovEditor(Lov lov, Locale locale) {
            if (lov != null) {
                String title = LovServiceImpl.this.messageSource.getMessage(lov.getTitle(), null, lov.getTitle(), locale);
                this.setTitle(title);
                this.setTextField(lov.getTextField());
                this.setValueField(lov.getValueField());
                this.setPlaceholder(LovServiceImpl.this.messageSource.getMessage(lov.getPlaceholder(), null, lov.getTitle(), locale));
                if ("Y".equals(lov.getEditableFlag())) {
                    this.setReadonly(false);
                }
                this.setPopup("Y".equals(lov.getCanPopup()));
            }
            for (LovItem item : lov.getLovItems()) {
                if (!"Y".equals(item.getIsAutocomplete())) continue;
                this.setAutocomplete(true);
                this.setAutocompleteField(item.getGridFieldName());
                break;
            }
        }

        public boolean getPopup() {
            return this.popup;
        }

        public void setPopup(boolean popup) {
            this.popup = popup;
        }

        public Boolean getReadonly() {
            return this.readonly;
        }

        public void setReadonly(Boolean readonly) {
            this.readonly = readonly;
        }

        public String getAutocompleteField() {
            return this.autocompleteField;
        }

        public void setAutocompleteField(String autocompleteField) {
            this.autocompleteField = autocompleteField;
        }

        public boolean getAutocomplete() {
            return this.autocomplete;
        }

        public void setAutocomplete(boolean autocomplete) {
            this.autocomplete = autocomplete;
        }

        public LovCondition getCondition() {
            return this.condition;
        }

        public void setCondition(LovCondition condition) {
            this.condition = condition;
        }

        public LovGrid getGrid() {
            return this.grid;
        }

        public void setGrid(LovGrid grid) {
            this.grid = grid;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValueField() {
            return this.valueField;
        }

        public void setValueField(String valueField) {
            this.valueField = valueField;
        }

        public String getTextField() {
            return this.textField;
        }

        public void setTextField(String textField) {
            this.textField = textField;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getPlaceholder() {
            return this.placeholder;
        }

        public void setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
        }
    }
}

