/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers.sys;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.Profile;
import com.hand.hap.system.dto.ProfileValue;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.IProfileService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys", "/api/sys"})
public class ProfileController
extends BaseController {
    @Autowired
    private IProfileService profileService;

    @RequestMapping(value={"/profile/query"})
    @ResponseBody
    public ResponseData getProfiles(Profile profile, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        return new ResponseData(this.profileService.selectProfiles(profile, page, pagesize));
    }

    @RequestMapping(value={"/profilevalue/query"})
    @ResponseBody
    public ResponseData getProfileValues(ProfileValue value) {
        return new ResponseData(this.profileService.selectProfileValues(value));
    }

    @RequestMapping(value={"/profilevalue/querylevelvalues"})
    @ResponseBody
    public ResponseData getLevelValues(ProfileValue value, Long levelId, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        return new ResponseData(this.profileService.selectLevelValues(value, levelId, page, pagesize));
    }

    @RequestMapping(value={"/profile/submit"}, method={RequestMethod.POST})
    public ResponseData submitProfiles(@RequestBody List<Profile> profiles, BindingResult result, HttpServletRequest request) {
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.profileService.batchUpdate(requestContext, profiles));
    }

    @RequestMapping(value={"/profile/remove"}, method={RequestMethod.POST})
    public ResponseData deleteProfile(@RequestBody List<Profile> profiles, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        this.profileService.batchDelete(requestContext, profiles);
        return new ResponseData();
    }

    @RequestMapping(value={"/profilevalue/remove"}, method={RequestMethod.POST})
    public ResponseData removeProfileValues(@RequestBody List<ProfileValue> profileValues, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        this.profileService.batchDeleteValues(requestContext, profileValues);
        return new ResponseData();
    }
}

