/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.cache.Cache;
import com.hand.hap.cache.CacheManager;
import com.hand.hap.cache.impl.HotkeyCache;
import com.hand.hap.cache.impl.SysCodeCache;
import com.hand.hap.core.ILanguageProvider;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.DefaultTlTableNameProvider;
import com.hand.hap.core.util.RequestUtil;
import com.hand.hap.message.components.DefaultPromptListener;
import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.Code;
import com.hand.hap.system.dto.CodeValue;
import com.hand.hap.system.dto.DTOClassInfo;
import com.hand.hap.system.dto.Hotkey;
import com.hand.hap.system.dto.Language;
import com.hand.hap.system.dto.MultiLanguageField;
import com.hand.hap.system.dto.Prompt;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.mapper.MultiLanguageMapper;
import com.hand.hap.system.service.ILovService;
import com.hand.hap.system.service.IProfileService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.persistence.Table;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;

@RestController
public class CommonController
extends BaseController {
    private Logger logger = LoggerFactory.getLogger(CommonController.class);
    @Autowired
    private MultiLanguageMapper multiLanguageMapper;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private ILovService commonLovService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ILanguageProvider languageProvider;
    @Autowired
    private IProfileService profileService;
    @Autowired
    private DefaultPromptListener promptListener;

    private String getCommonPrompts(String lang) {
        List<Prompt> list = this.promptListener.getDefaultPrompt(lang);
        if (list == null) {
            return "//null";
        }
        StringBuilder sb = new StringBuilder();
        for (Prompt prompt : list) {
            sb.append("$l('").append(prompt.getPromptCode().toLowerCase()).append("','").append(prompt.getDescription()).append("');\n");
        }
        sb.append("//").append(list.size());
        return sb.toString();
    }

    @RequestMapping(value={"/common/{resource}"}, produces={"application/javascript;charset=utf8"})
    @ResponseBody
    public String getCommonData(@PathVariable String resource, @RequestParam Map<String, String> params, HttpServletRequest request) throws JsonProcessingException {
        String lang;
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        String string = lang = locale == null ? null : locale.toString();
        if ("prompts".equalsIgnoreCase(resource)) {
            return this.getCommonPrompts(lang);
        }
        Cache cache = this.cacheManager.getCache(resource);
        String var = params.get("var");
        StringBuilder sb = new StringBuilder();
        if (cache instanceof SysCodeCache) {
            params.forEach((k, v) -> {
                block8: {
                    Code code = ((SysCodeCache)cache).getValue(v + "." + lang);
                    try {
                        if (code == null) {
                            this.toJson(sb, (String)k, Collections.EMPTY_LIST);
                        } else if ("N".equals(code.getEnabledFlag())) {
                            this.toJson(sb, (String)k, Collections.EMPTY_LIST);
                        } else {
                            List<CodeValue> enabledCodeValues = this.getEnabledCodeValues(code);
                            if (enabledCodeValues == null) {
                                this.toJson(sb, (String)k, Collections.EMPTY_LIST);
                            } else {
                                this.toJson(sb, (String)k, enabledCodeValues);
                            }
                        }
                        sb.append("\n");
                    }
                    catch (JsonProcessingException e) {
                        if (!this.logger.isErrorEnabled()) break block8;
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        } else if ("language".equals(resource)) {
            List<Language> data = this.languageProvider.getSupportedLanguages();
            this.toJson(sb, var, data);
        } else if ("hotkey".equals(resource)) {
            IRequest iRequest = this.createRequestContext(request);
            List<HotkeyData> data = this.getCommonHotkeys(iRequest, (HotkeyCache)cache);
            this.toJson(sb, "hotKeys", data);
        }
        return sb.toString();
    }

    private List<CodeValue> getEnabledCodeValues(Code code) {
        ArrayList<CodeValue> enabledCodeValues = new ArrayList<CodeValue>();
        List<CodeValue> allCodeValues = code.getCodeValues();
        if (allCodeValues != null) {
            for (CodeValue codevalue : allCodeValues) {
                if (!"Y".equals(codevalue.getEnabledFlag())) continue;
                enabledCodeValues.add(codevalue);
            }
        }
        return enabledCodeValues;
    }

    @RequestMapping(value={"/common/code/{code}/"}, produces={"application/javascript;charset=utf8"})
    @ResponseBody
    public String getCommonCode(@PathVariable String code, HttpServletRequest request) throws JsonProcessingException {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        SysCodeCache codeCache = (SysCodeCache)this.cacheManager.getCache("code");
        Code code2 = codeCache.getValue(code + "." + locale);
        if (code2 == null) {
            return "[]";
        }
        if ("N".equals(code2.getEnabledFlag())) {
            return "[]";
        }
        List<CodeValue> enabledCodeValues = this.getEnabledCodeValues(code2);
        if (enabledCodeValues == null) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        this.toJson(sb, null, enabledCodeValues);
        return sb.toString();
    }

    @RequestMapping(value={"/common/lov/{id}"})
    @ResponseBody
    public ResponseData getLovDatas(@PathVariable String id, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize, @RequestParam Map<String, String> params, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.commonLovService.selectDatas(requestContext, id, params, page, pagesize));
    }

    @RequestMapping(value={"/{folder1}/{name}.html", "/{folder1}/{name}.view"})
    public ModelAndView renderFolder1View(@PathVariable String folder1, @PathVariable String name, Model model) {
        return new ModelAndView(this.getViewPath() + "/" + folder1 + "/" + name);
    }

    @RequestMapping(value={"/{folder1}/{folder2}/{name}.html", "/{folder1}/{folder2}/{name}.view"})
    public ModelAndView renderFolder2View(@PathVariable String folder1, @PathVariable String folder2, @PathVariable String name, Model model) {
        return new ModelAndView(this.getViewPath() + "/" + folder1 + "/" + folder2 + "/" + name);
    }

    @RequestMapping(value={"/{folder1}/{folder2}/{folder3}/{name}.html", "/{folder1}/{folder2}/{folder3}/{name}.view"})
    public ModelAndView renderFolder3View(@PathVariable String folder1, @PathVariable String folder2, @PathVariable String folder3, @PathVariable String name, Model model) {
        return new ModelAndView(this.getViewPath() + "/" + folder1 + "/" + folder2 + "/" + folder3 + "/" + name);
    }

    @RequestMapping(value={"/{folder1}/{folder2}/{folder3}/{folder4}/{name}.html", "/{folder1}/{folder2}/{folder3}/{folder4}/{name}.view"})
    public ModelAndView renderFolder4View(@PathVariable String folder1, @PathVariable String folder2, @PathVariable String folder3, @PathVariable String folder4, @PathVariable String name, Model model) {
        return new ModelAndView(this.getViewPath() + "/" + folder1 + "/" + folder2 + "/" + folder3 + "/" + folder4 + "/" + name);
    }

    @RequestMapping(value={"/{name}.html", "/{name}.view"})
    public ModelAndView renderView(@PathVariable String name, Model model) {
        return new ModelAndView(name);
    }

    protected void toJson(StringBuilder sb, String var, Object data) throws JsonProcessingException {
        boolean hasVar;
        boolean bl = hasVar = var != null && var.length() > 0;
        if (hasVar) {
            sb.append("var ").append(var).append('=');
        }
        sb.append(this.objectMapper.writeValueAsString(data));
        if (hasVar) {
            sb.append(';');
        }
    }

    @RequestMapping(value={"sys/sys_multilanguage_editor.html"})
    public ModelAndView loadMultiLanguageFields(HttpServletRequest request, @RequestParam String id, @RequestParam String dto, @RequestParam String field) {
        ModelAndView view;
        block5: {
            view = new ModelAndView(this.getViewPath() + "/sys/sys_multilanguage_editor");
            if (StringUtils.isNotEmpty((String)id) && StringUtils.isNotEmpty((String)dto) && StringUtils.isNotEmpty((String)field)) {
                try {
                    Class<?> clazz = Class.forName(dto);
                    Table table = clazz.getAnnotation(Table.class);
                    EntityField idField = DTOClassInfo.getIdFields(clazz)[0];
                    EntityField tlField = DTOClassInfo.getEntityField(clazz, field);
                    if (table != null && idField != null && tlField != null) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("table", DefaultTlTableNameProvider.getInstance().getTlTableName(table.name()));
                        map.put("idName", DTOClassInfo.getColumnName(idField));
                        map.put("tlName", DTOClassInfo.getColumnName(tlField));
                        map.put("id", id);
                        List<MultiLanguageField> list = this.multiLanguageMapper.select(map);
                        view.addObject("list", list);
                    }
                    break block5;
                }
                catch (Exception e) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    break block5;
                }
            }
            List<Language> list = this.languageProvider.getSupportedLanguages();
            list.sort((a, b) -> a.getLangCode().compareTo(b.getLangCode()));
            view.addObject("list", list);
        }
        return view;
    }

    @RequestMapping(value={"/sys/multiLanguage"}, method={RequestMethod.GET})
    public Map<String, Object> loadMultiLanguageFields2(HttpServletRequest request, @RequestParam String id, @RequestParam String dto, @RequestParam String field) {
        HashMap<String, Object> result;
        block5: {
            result = new HashMap<String, Object>();
            if (StringUtils.isNotEmpty((String)id) && StringUtils.isNotEmpty((String)dto) && StringUtils.isNotEmpty((String)field)) {
                try {
                    Class<?> clazz = Class.forName(dto);
                    Table table = clazz.getAnnotation(Table.class);
                    EntityField idField = DTOClassInfo.getIdFields(clazz)[0];
                    EntityField tlField = DTOClassInfo.getEntityField(clazz, field);
                    if (table != null && idField != null && tlField != null) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("table", DefaultTlTableNameProvider.getInstance().getTlTableName(table.name()));
                        map.put("idName", DTOClassInfo.getColumnName(idField));
                        map.put("tlName", DTOClassInfo.getColumnName(tlField));
                        map.put("id", id);
                        result.put("multiLanguages", this.multiLanguageMapper.select(map));
                    }
                    break block5;
                }
                catch (Exception e) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    break block5;
                }
            }
            List<Language> list = this.languageProvider.getSupportedLanguages();
            list.sort((a, b) -> a.getLangCode().compareTo(b.getLangCode()));
            result.put("multiLanguages", list);
        }
        return result;
    }

    @RequestMapping(value={"/common/profile"}, produces={"application/javascript;charset=utf8"})
    @ResponseBody
    public String getProfile(@RequestParam Map<String, String> params, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        StringBuilder sb = new StringBuilder();
        params.put("a", "test");
        params.forEach((k, v) -> {
            block2: {
                String value = this.profileService.getProfileValue(requestContext, (String)v);
                try {
                    this.toJson(sb, (String)k, value);
                    sb.append("\n");
                }
                catch (JsonProcessingException e) {
                    if (!this.logger.isErrorEnabled()) break block2;
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        return sb.toString();
    }

    @RequestMapping(value={"/timeout"})
    public Object sessionTimeout(HttpServletRequest request, HttpServletResponse response) {
        if (RequestUtil.isAjaxRequest(request)) {
            ResponseData res = new ResponseData(false);
            res.setCode("sys_session_timeout");
            return res;
        }
        return new ModelAndView("timeout");
    }

    @RequestMapping(value={"/access-denied"})
    public Object accessDenied(HttpServletRequest request, HttpServletResponse response) {
        if (request.getSession(false) == null) {
            return this.sessionTimeout(request, response);
        }
        if (RequestUtil.isAjaxRequest(request)) {
            ResponseData res = new ResponseData(false);
            res.setCode("sys_access_denied");
            return res;
        }
        return new ModelAndView("403");
    }

    private HotkeyData getHotkeyData(Hotkey hotkey) {
        HotkeyData hotkeyData = new HotkeyData();
        HotkeyValue hotkeyValue = new HotkeyValue();
        String key = hotkey.getHotkey();
        hotkeyData.setCode(hotkey.getCode());
        hotkeyData.setHotkey(hotkeyValue.initValue(key, hotkeyValue));
        return hotkeyData;
    }

    private List<HotkeyData> getCommonHotkeys(IRequest iRequest, HotkeyCache cache) {
        HashMap<String, HotkeyData> hotkeyDatas = new HashMap<String, HotkeyData>();
        ArrayList<HotkeyData> data = new ArrayList<HotkeyData>();
        Hotkey[] hotkeysSys = cache.getValue("system_0");
        Hotkey[] hotkeyUser = cache.getValue("user_" + iRequest.getUserId());
        if (hotkeysSys != null) {
            for (Hotkey hotkey : hotkeysSys) {
                hotkeyDatas.put(hotkey.getCode(), this.getHotkeyData(hotkey));
            }
        }
        if (hotkeyUser != null) {
            for (Hotkey hotkey : hotkeyUser) {
                HotkeyData value = (HotkeyData)hotkeyDatas.get(hotkey.getCode());
                if (value == null) continue;
                hotkeyDatas.put(hotkey.getCode(), this.getHotkeyData(hotkey));
            }
        }
        data.addAll(hotkeyDatas.values());
        return data;
    }

    private class HotkeyData {
        private HotkeyValue hotkey;
        private String code;

        private HotkeyData() {
        }

        public HotkeyValue getHotkey() {
            return this.hotkey;
        }

        public void setHotkey(HotkeyValue hotkey) {
            this.hotkey = hotkey;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }
    }

    private class HotkeyValue {
        private boolean altKey = false;
        private boolean shiftKey = false;
        private boolean ctrlKey = false;
        private String keyValue = "";

        private HotkeyValue() {
        }

        public String getKeyValue() {
            return this.keyValue;
        }

        public void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        public boolean isAltKey() {
            return this.altKey;
        }

        public void setAltKey(boolean altKey) {
            this.altKey = altKey;
        }

        public boolean isShiftKey() {
            return this.shiftKey;
        }

        public void setShiftKey(boolean shiftKey) {
            this.shiftKey = shiftKey;
        }

        public boolean isCtrlKey() {
            return this.ctrlKey;
        }

        public void setCtrlKey(boolean ctrlKey) {
            this.ctrlKey = ctrlKey;
        }

        public HotkeyValue initValue(String key, HotkeyValue value) {
            if (key.indexOf("Ctrl") != -1) {
                value.setCtrlKey(true);
                key = key.replace("Ctrl", "");
            }
            if (key.indexOf("Alt") != -1) {
                value.setAltKey(true);
                key = key.replace("Alt", "");
            }
            if (key.indexOf("Shift") != -1) {
                value.setShiftKey(true);
                key = key.replace("Shift", "");
            }
            key = key.replace("+", "");
            value.setKeyValue(key);
            return value;
        }
    }
}

