/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.core.exception.TokenException;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.core.util.RequestUtil;
import com.hand.hap.core.validator.FieldErrorWithBean;
import com.hand.hap.security.DefaultConfiguration;
import com.hand.hap.security.TokenUtils;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.dto.ResponseData;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.ibatis.ognl.OgnlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;

@RestController
public class BaseController {
    protected static final String DEFAULT_PAGE = "1";
    protected static final String DEFAULT_PAGE_SIZE = "10";
    protected static final String SYS_VALIDATION_PREFIX = "hap.validation.";
    protected static final String DEFAULT_VIEW_HOME = "";
    @Autowired
    private DefaultConfiguration configuration;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Validator validator;
    private Logger logger = LoggerFactory.getLogger(BaseController.class);

    protected String getViewPath() {
        if (this.configuration != null) {
            return this.configuration.getDefaultViewPath();
        }
        return DEFAULT_VIEW_HOME;
    }

    protected Validator getValidator() {
        return this.validator;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder, HttpServletRequest request) {
        Object target = dataBinder.getTarget();
    }

    protected IRequest createRequestContext(HttpServletRequest request) {
        return RequestHelper.createServiceRequest(request);
    }

    protected void checkToken(HttpServletRequest request, Collection<? extends BaseDTO> dtos) throws TokenException {
        if (request != null) {
            this.checkToken(request.getSession(false), dtos);
        }
    }

    protected void checkToken(HttpSession session, Collection<? extends BaseDTO> dtos) throws TokenException {
        TokenUtils.checkToken(session, dtos);
    }

    protected void checkToken(HttpServletRequest request, BaseDTO baseDTO) throws TokenException {
        if (request != null) {
            this.checkToken(request.getSession(false), baseDTO);
        }
    }

    protected void checkToken(HttpSession session, BaseDTO baseDTO) throws TokenException {
        TokenUtils.checkToken(session, baseDTO);
    }

    @ExceptionHandler(value={Exception.class})
    public Object exceptionHandler(Exception exception, HttpServletRequest request) {
        this.logger.error(exception.getMessage(), (Throwable)exception);
        Throwable thr = this.getRootCause(exception);
        if (RequestUtil.isAjaxRequest(request) || RequestUtil.isAPIRequest(request) || ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ResponseData res = new ResponseData(false);
            if (thr instanceof BaseException) {
                BaseException be = (BaseException)thr;
                Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
                String messageKey = be.getDescriptionKey();
                String message = this.messageSource.getMessage(messageKey, be.getParameters(), messageKey, locale);
                res.setCode(be.getCode());
                res.setMessage(message);
            } else {
                res.setMessage(thr.toString());
            }
            return res;
        }
        ModelAndView view = new ModelAndView("500");
        if (thr instanceof BaseException) {
            BaseException be = (BaseException)thr;
            Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
            String messageKey = be.getDescriptionKey();
            String message = this.messageSource.getMessage(messageKey, be.getParameters(), messageKey, locale);
            view.addObject("message", (Object)message);
        }
        return view;
    }

    protected String getErrorMessage(Errors errors, HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        String errorMessage = null;
        for (ObjectError error : errors.getAllErrors()) {
            if (error.getDefaultMessage() != null) {
                if (error instanceof FieldErrorWithBean) {
                    errorMessage = this.getStandardFieldErrorMessage((FieldErrorWithBean)error, locale);
                    break;
                }
                errorMessage = this.messageSource.getMessage(error.getDefaultMessage(), null, locale);
                break;
            }
            errorMessage = error.getCode();
        }
        return errorMessage;
    }

    protected String nls(HttpServletRequest request, String code, Object[] args) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        return this.messageSource.getMessage(code, args, code, locale);
    }

    protected String nls(HttpServletRequest request, String code) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        return this.messageSource.getMessage(code, null, code, locale);
    }

    protected String getStandardFieldErrorMessage(FieldErrorWithBean fieldError, Locale locale) {
        String msg;
        String field = fieldError.getField();
        Class clazz = fieldError.getTargetBean().getClass();
        clazz = this.findDeclareClass(clazz, field);
        String fieldPromptMessageKey = clazz.getSimpleName() + "." + field;
        String fieldPrompt = this.messageSource.getMessage(fieldPromptMessageKey.toLowerCase(), null, locale);
        String code = SYS_VALIDATION_PREFIX + fieldError.getCode().toLowerCase();
        if (code.equalsIgnoreCase(msg = this.messageSource.getMessage(code, new Object[]{fieldPrompt}, fieldError.getDefaultMessage(), locale)) && fieldError.getDefaultMessage() != null) {
            msg = fieldPrompt + " : " + fieldError.getDefaultMessage();
        }
        return msg;
    }

    private Class findDeclareClass(Class fromClass, String fieldName) {
        Class clazz = fromClass;
        while (clazz.getSuperclass() != null) {
            try {
                clazz.getDeclaredField(fieldName);
                return clazz;
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return fromClass;
    }

    private Throwable getRootCause(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof OgnlException && ((OgnlException)throwable).getReason() != null) {
            return this.getRootCause(((OgnlException)throwable).getReason());
        }
        return throwable;
    }

    protected Long getUserId(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return (Long)session.getAttribute("userId");
    }

    protected Long getRoleId(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return (Long)session.getAttribute("roleId");
    }

    protected String getLanguage(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return (String)session.getAttribute("locale");
    }
}

