/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.permission.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.security.permission.dto.DataPermissionTableRule;
import com.hand.hap.security.permission.service.IDataPermissionTableRuleService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DataPermissionTableRuleController
extends BaseController {
    @Autowired
    private IDataPermissionTableRuleService service;

    @RequestMapping(value={"/sys/data/permission/table/rule/query"})
    @ResponseBody
    public ResponseData query(DataPermissionTableRule dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.selectOptions(requestContext, dto, null, page, pageSize));
    }

    @RequestMapping(value={"/sys/data/permission/table/rule/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<DataPermissionTableRule> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.updateRule(requestCtx, dto));
    }

    @RequestMapping(value={"/sys/data/permission/table/rule/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<DataPermissionTableRule> dto) {
        this.service.removeRule(dto);
        return new ResponseData();
    }
}

