/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.permission;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.components.ApplicationContextHelper;
import com.hand.hap.security.permission.dto.Limit;
import com.hand.hap.security.permission.service.impl.DataPermissionParameterMappingTokenHandler;
import com.hand.hap.security.permission.service.impl.DataPermissionRangeFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPermissionUtil {
    private static Logger logger = LoggerFactory.getLogger(DataPermissionUtil.class);
    static Map<String, DataPermissionRangeFilter> rangeFilter = ApplicationContextHelper.getApplicationContext().getBeansOfType(DataPermissionRangeFilter.class);

    public static String getNewSql(String oldSql, IRequest request) {
        Select select;
        if (null == request || request.getUserId().toString().equals("-1") || request.getAllRoleId().length == 0) {
            return oldSql;
        }
        try {
            select = (Select)CCJSqlParserUtil.parse((String)oldSql);
        }
        catch (JSQLParserException e) {
            logger.error("Parse SQL Error,Skip DATA_PERMISSION", (Throwable)e);
            return oldSql;
        }
        try {
            DataPermissionUtil.analysisSql(select.getSelectBody(), request);
        }
        catch (ExecutionException e) {
            logger.error("Create New SQL Error,Skip DATA_PERMISSION", (Throwable)e);
            return oldSql;
        }
        catch (JSQLParserException e) {
            logger.error("Create New SQL Error,Skip DATA_PERMISSION", (Throwable)e);
            return oldSql;
        }
        net.sf.jsqlparser.statement.select.Limit mit = null;
        if (select.getSelectBody() instanceof SetOperationList) {
            mit = ((SetOperationList)select.getSelectBody()).getLimit();
        } else if (select.getSelectBody() instanceof PlainSelect) {
            mit = ((PlainSelect)select.getSelectBody()).getLimit();
        }
        if (mit != null) {
            Limit limit = new Limit(mit);
            ((PlainSelect)select.getSelectBody()).setLimit((net.sf.jsqlparser.statement.select.Limit)limit);
        }
        return select.toString();
    }

    private static void analysisSql(SelectBody selectBody, IRequest request) throws ExecutionException, JSQLParserException {
        if (selectBody instanceof PlainSelect) {
            DataPermissionUtil.parserSql((PlainSelect)selectBody, request);
        } else if (selectBody instanceof SetOperationList) {
            SetOperationList list = (SetOperationList)selectBody;
            for (int i = 0; i < list.getSelects().size(); ++i) {
                DataPermissionUtil.parserSql((PlainSelect)list.getSelects().get(i), request);
            }
        }
    }

    private static void parserSql(PlainSelect select, IRequest request) throws ExecutionException, JSQLParserException {
        List joins;
        FromItem fromItem = select.getFromItem();
        if (fromItem instanceof SubSelect) {
            DataPermissionUtil.analysisSql(((SubSelect)fromItem).getSelectBody(), request);
        }
        if (null != (joins = select.getJoins())) {
            for (Join join : joins) {
                if (!(join.getRightItem() instanceof SubSelect)) continue;
                DataPermissionUtil.analysisSql(((SubSelect)join.getRightItem()).getSelectBody(), request);
            }
        }
        DataPermissionUtil.doParserSql(select, request);
    }

    private static void doParserSql(PlainSelect select, IRequest request) throws ExecutionException, JSQLParserException {
        List joins;
        SubSelect subSelect;
        FromItem fromItem = select.getFromItem();
        if (fromItem instanceof Table && null != (subSelect = DataPermissionUtil.getTableView((Table)fromItem, request))) {
            select.setFromItem((FromItem)subSelect);
        }
        if (null != (joins = select.getJoins())) {
            for (Join join : joins) {
                SubSelect subSelect2;
                if (!(join.getRightItem() instanceof Table) || null == (subSelect2 = DataPermissionUtil.getTableView((Table)join.getRightItem(), request))) continue;
                join.setRightItem((FromItem)subSelect2);
            }
        }
    }

    private static void parseWhere(Expression expression, IRequest request) throws ExecutionException, JSQLParserException {
        if (null == expression) {
            return;
        }
        if (expression instanceof BinaryExpression) {
            Expression rightExp = ((BinaryExpression)expression).getRightExpression();
            Expression leftExp = ((BinaryExpression)expression).getLeftExpression();
            DataPermissionUtil.parseWhere(rightExp, request);
            DataPermissionUtil.parseWhere(leftExp, request);
        } else if (expression instanceof InExpression) {
            InExpression inExpression = (InExpression)expression;
            if (null != inExpression.getRightItemsList() && inExpression.getRightItemsList() instanceof SubSelect) {
                DataPermissionUtil.parseWhere((Expression)((SubSelect)inExpression.getRightItemsList()), request);
            }
        } else if (expression instanceof SubSelect) {
            DataPermissionUtil.parserSql((PlainSelect)((SubSelect)expression).getSelectBody(), request);
        }
    }

    private static SubSelect getTableView(Table table, IRequest request) throws JSQLParserException, ExecutionException {
        HashMap<String, Set> map = new HashMap<String, Set>();
        for (Map.Entry<String, DataPermissionRangeFilter> entry : rangeFilter.entrySet()) {
            entry.getValue().doFilter(request, table.getName(), map);
        }
        if (map.size() == 0) {
            return null;
        }
        PlainSelect plainSelect = (PlainSelect)DataPermissionUtil.createTableView(map, table.getName(), request).getSelectBody();
        SubSelect tableView = new SubSelect();
        tableView.setSelectBody((SelectBody)plainSelect);
        if (null != table.getAlias()) {
            tableView.setAlias(table.getAlias());
        } else {
            Alias alias = new Alias(table.getName());
            alias.setUseAs(false);
            tableView.setAlias(alias);
        }
        return tableView;
    }

    private static Select createTableView(Map<String, Set> map, String tableName, IRequest iRequest) throws JSQLParserException {
        String newSql = "SELECT * FROM " + tableName + " WHERE ";
        for (Map.Entry<String, Set> mapEntry : map.entrySet()) {
            int i;
            String[] iSet;
            String in;
            Set inSet = mapEntry.getValue();
            String columnField = mapEntry.getKey();
            if (inSet.size() == 0) continue;
            if (!columnField.equals("_PERMISSION_CUSTOM_SQL")) {
                if (inSet.size() == 1) {
                    newSql = newSql + columnField + " = '" + inSet.toArray()[0].toString() + "'";
                } else {
                    in = "";
                    iSet = inSet.toArray(new String[inSet.size()]);
                    for (i = 0; i < iSet.length; ++i) {
                        in = in + "'" + iSet[i] + "'";
                        if (i == iSet.length - 1) continue;
                        in = in + ",";
                    }
                    newSql = newSql + columnField + " in ( " + in + " )";
                }
            } else {
                in = "";
                iSet = inSet.toArray(new String[inSet.size()]);
                for (i = 0; i < iSet.length; ++i) {
                    in = in + " ( " + DataPermissionUtil.addCriteriaIfDynamicSql(iSet[i], iRequest) + " ) ";
                    if (i == iSet.length - 1) continue;
                    in = in + " and ";
                }
                newSql = newSql + in;
            }
            newSql = newSql + " and ";
        }
        newSql = newSql.substring(0, newSql.length() - 5);
        return (Select)CCJSqlParserUtil.parse((String)newSql);
    }

    private static String addCriteriaIfDynamicSql(String oldSql, IRequest iRequest) {
        DataPermissionParameterMappingTokenHandler handler = new DataPermissionParameterMappingTokenHandler(iRequest);
        GenericTokenParser parser = new GenericTokenParser("#{", "}", (TokenHandler)handler);
        return parser.parse(oldSql);
    }
}

