/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.oauth.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.security.oauth.dto.TokenLogs;
import com.hand.hap.security.oauth.service.ITokenLogsService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class TokenLogsController
extends BaseController {
    @Autowired
    private ITokenLogsService service;
    @Autowired
    @Qualifier(value="tokenServices")
    private ConsumerTokenServices tokenServices;

    @RequestMapping(value={"/sys/token/logs/query"})
    @ResponseBody
    public ResponseData query(TokenLogs dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/sys/token/logs/revoke"})
    @ResponseBody
    public ResponseData revoke(HttpServletRequest request, @RequestParam String token) {
        this.tokenServices.revokeToken(token);
        return new ResponseData();
    }
}

