/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import com.hand.hap.message.profile.SystemConfigListener;
import com.hand.hap.mybatis.util.StringUtil;
import com.hand.hap.security.IAuthenticationSuccessListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;

public class CustomAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler
implements SystemConfigListener {
    @Autowired
    private ApplicationContext applicationContext;
    private RequestCache requestCache = new HttpSessionRequestCache();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CustomAuthenticationSuccessHandler() {
        this.setDefaultTargetUrl("/index");
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        SavedRequest savedRequest;
        String referer = request.getHeader("Referer");
        if (referer != null && referer.endsWith("/login?oauth")) {
            super.onAuthenticationSuccess(request, response, authentication);
            return;
        }
        this.clearAuthenticationAttributes(request);
        Map listeners = this.applicationContext.getBeansOfType(IAuthenticationSuccessListener.class);
        ArrayList list = new ArrayList();
        list.addAll(listeners.values());
        Collections.sort(list);
        IAuthenticationSuccessListener successListener = null;
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IAuthenticationSuccessListener listener;
                successListener = listener = (IAuthenticationSuccessListener)iterator.next();
                successListener.onAuthenticationSuccess(request, response, authentication);
            }
            HttpSession session = request.getSession(false);
            session.setAttribute("login_change_index", (Object)"CHANGE");
        }
        catch (Exception e) {
            this.logger.error("authentication success, but error occurred in " + successListener, (Throwable)e);
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
            request.setAttribute("error", (Object)true);
            request.setAttribute("exception", (Object)e);
            request.getRequestDispatcher("/login").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String requestURI = request.getRequestURI();
        boolean isCas = requestURI.endsWith("/login/cas");
        if (isCas && (savedRequest = this.requestCache.getRequest(request, response)) != null) {
            String targetUrl = savedRequest.getRedirectUrl();
            String defaultTarget = this.getDefaultTargetUrl();
            if (!"/index".equalsIgnoreCase(defaultTarget)) {
                targetUrl = this.getDefaultTargetUrl() + "?targetUrl=" + targetUrl;
            }
            this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
            return;
        }
        this.handle(request, response, authentication);
    }

    @Override
    public List<String> getAcceptedProfiles() {
        return Arrays.asList("DEFAULT_TARGET_URL");
    }

    @Override
    public void updateProfile(String profileName, String profileValue) {
        if (StringUtil.isNotEmpty(profileValue)) {
            this.setDefaultTargetUrl(profileValue);
        }
    }
}

