/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.report.service.impl;

import com.hand.hap.report.dto.Report;
import com.hand.hap.report.mapper.ReportMapper;
import com.hand.hap.report.service.IReportService;
import com.hand.hap.system.mapper.ParameterConfigMapper;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ReportServiceImpl
extends BaseServiceImpl<Report>
implements IReportService {
    @Autowired
    private ReportMapper reportMapper;
    @Autowired
    private ParameterConfigMapper parameterConfigMapper;

    @Override
    public int batchDelete(List<Report> reports) {
        if (CollectionUtils.isNotEmpty(reports)) {
            for (Report report : reports) {
                int updateCount = this.reportMapper.deleteByPrimaryKey(report);
                this.checkOvn(updateCount, report);
                this.parameterConfigMapper.deleteByCodeAndTargetId("REPORT", report.getReportId());
            }
        }
        return 1;
    }

    @Override
    protected boolean useSelectiveUpdate() {
        return false;
    }

    @Override
    public List<Report> selectByReportCode(String reportCode) {
        return this.reportMapper.selectByReportCode(reportCode);
    }
}

