/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.report;

import com.bstek.ureport.provider.report.ReportFile;
import com.bstek.ureport.provider.report.ReportProvider;
import com.hand.hap.report.dto.ReportFiles;
import com.hand.hap.report.service.IReportFilesService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DataBaseReportProvider
implements ReportProvider {
    private final Logger logger = LoggerFactory.getLogger(DataBaseReportProvider.class);
    private String prefix = "database:";
    private boolean disabled;
    @Autowired
    private IReportFilesService reportFilesService;

    public InputStream loadReport(String name) {
        ReportFiles reportFile = this.reportFilesService.selectByName(this.removePrefix(name));
        if (reportFile != null) {
            try {
                return IOUtils.toInputStream((String)reportFile.getContent(), (String)"utf-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String removePrefix(String name) {
        if (name.startsWith(this.prefix)) {
            name = name.substring(this.prefix.length(), name.length());
        }
        name = name.split(".xml")[0] + ".xml";
        return name;
    }

    public void deleteReport(String name) {
        this.reportFilesService.deleteByName(this.removePrefix(name));
    }

    public List<ReportFile> getReportFiles() {
        ArrayList<ReportFile> list = new ArrayList<ReportFile>();
        List<ReportFiles> reports = this.reportFilesService.selectOptions(null, new ReportFiles(), null);
        reports.forEach(report -> list.add(new ReportFile(report.getName(), report.getLastUpdateDate())));
        list.sort((rf1, rf2) -> rf2.getUpdateDate().compareTo(rf1.getUpdateDate()));
        return list;
    }

    public void saveReport(String name, String content) {
        ReportFiles reportFiles = this.reportFilesService.selectByName(this.removePrefix(name));
        if (reportFiles != null) {
            reportFiles.setContent(content);
            reportFiles.setParams(this.getParams(content));
            this.reportFilesService.updateByPrimaryKey(null, reportFiles);
        } else {
            reportFiles = new ReportFiles();
            reportFiles.setName(this.removePrefix(name));
            reportFiles.setContent(content);
            reportFiles.setParams(this.getParams(content));
            reportFiles.setObjectVersionNumber(1L);
            this.reportFilesService.insertSelective(null, reportFiles);
        }
    }

    private String getParams(String content) {
        StringBuffer params = new StringBuffer("");
        JSONObject ureport = XML.toJSONObject((String)content).getJSONObject("ureport");
        if (ureport.has("datasource")) {
            this.obtainDatasource(ureport, params);
        }
        return params.toString();
    }

    private void obtainDatasource(JSONObject ureport, StringBuffer params) {
        Object dataSourceObj = ureport.get("datasource");
        if (dataSourceObj instanceof JSONObject) {
            JSONObject dataSource = (JSONObject)dataSourceObj;
            this.obtainDataSet(dataSource, params);
        } else if (dataSourceObj instanceof JSONArray) {
            JSONArray dataSources = (JSONArray)dataSourceObj;
            for (int i = 0; i < dataSources.length(); ++i) {
                JSONObject dataSource = (JSONObject)dataSources.get(i);
                this.obtainDataSet(dataSource, params);
            }
        }
    }

    private void obtainDataSet(JSONObject dataSource, StringBuffer params) {
        if (dataSource.has("dataset")) {
            Object dataSetObj = dataSource.get("dataset");
            if (dataSetObj instanceof JSONObject) {
                JSONObject dataSet = (JSONObject)dataSetObj;
                this.obtainParameter(dataSet, params);
            } else if (dataSetObj instanceof JSONArray) {
                JSONArray dataSets = (JSONArray)dataSetObj;
                for (int i = 0; i < dataSets.length(); ++i) {
                    JSONObject dataSet = (JSONObject)dataSets.get(i);
                    this.obtainParameter(dataSet, params);
                }
            }
        }
    }

    private void obtainParameter(JSONObject dataSet, StringBuffer params) {
        if (dataSet.has("parameter")) {
            Object parameterObj = dataSet.get("parameter");
            if (parameterObj instanceof JSONObject) {
                JSONObject parameter = (JSONObject)parameterObj;
                params.append(parameter.get("name") + ";");
            } else if (parameterObj instanceof JSONArray) {
                JSONArray parameters = (JSONArray)parameterObj;
                for (int i = 0; i < parameters.length(); ++i) {
                    JSONObject parameter = (JSONObject)parameters.get(i);
                    params.append(parameter.get("name") + ";");
                }
            }
        }
    }

    public String getName() {
        return "\u6570\u636e\u5e93\u5b58\u50a8\u7cfb\u7edf";
    }

    public boolean disabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

