/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mybatis.mapperhelper;

import com.hand.hap.core.annotation.MultiLanguage;
import com.hand.hap.core.annotation.MultiLanguageField;
import com.hand.hap.mybatis.annotation.ColumnType;
import com.hand.hap.mybatis.annotation.Condition;
import com.hand.hap.mybatis.annotation.ExtensionAttribute;
import com.hand.hap.mybatis.annotation.NameStyle;
import com.hand.hap.mybatis.code.IdentityDialect;
import com.hand.hap.mybatis.code.Style;
import com.hand.hap.mybatis.common.query.Comparison;
import com.hand.hap.mybatis.common.query.JoinColumn;
import com.hand.hap.mybatis.common.query.JoinOn;
import com.hand.hap.mybatis.common.query.JoinTable;
import com.hand.hap.mybatis.common.query.Where;
import com.hand.hap.mybatis.entity.Config;
import com.hand.hap.mybatis.entity.EntityColumn;
import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.mybatis.entity.EntityTable;
import com.hand.hap.mybatis.mapperhelper.FieldHelper;
import com.hand.hap.mybatis.util.StringUtil;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.criteria.JoinType;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.UnknownTypeHandler;

public class EntityHelper {
    private static final Map<Class<?>, EntityTable> entityTableMap = new HashMap();

    private EntityHelper() {
    }

    public static EntityTable getEntityTable(Class<?> entityClass) {
        EntityTable entityTable = entityTableMap.get(entityClass);
        if (entityTable == null) {
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u5bf9\u5e94\u7684\u8868\u540d!");
        }
        return entityTable;
    }

    public static EntityTable getEntityTable(String tableName) {
        EntityTable entityTable = null;
        for (EntityTable entity : entityTableMap.values()) {
            if (!entity.getName().equalsIgnoreCase(tableName)) continue;
            entityTable = entity;
            break;
        }
        if (null == entityTable) {
            throw new RuntimeException("\u65e0\u6cd5\u901a\u8fc7\u8868\u540d" + tableName + "\u83b7\u53d6\u5bf9\u5e94\u7684\u8868\u5b9e\u4f53\u7c7b!");
        }
        return entityTable;
    }

    public static String buildJoinKey(JoinTable jt) {
        return jt.target().getCanonicalName() + "." + jt.name();
    }

    public static String getOrderByClause(Class<?> entityClass) {
        EntityTable table = EntityHelper.getEntityTable(entityClass);
        if (table.getOrderByClause() != null) {
            return table.getOrderByClause();
        }
        StringBuilder orderBy = new StringBuilder();
        for (EntityColumn column : table.getEntityClassColumns()) {
            if (column.getOrderBy() == null) continue;
            if (orderBy.length() != 0) {
                orderBy.append(",");
            }
            orderBy.append(column.getColumn()).append(" ").append(column.getOrderBy());
        }
        table.setOrderByClause(orderBy.toString());
        return table.getOrderByClause();
    }

    public static Set<EntityColumn> getColumns(Class<?> entityClass) {
        return EntityHelper.getEntityTable(entityClass).getEntityClassColumns();
    }

    public static Set<EntityColumn> getPKColumns(Class<?> entityClass) {
        return EntityHelper.getEntityTable(entityClass).getEntityClassPKColumns();
    }

    public static String getSelectColumns(Class<?> entityClass) {
        EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        if (entityTable.getBaseSelect() != null) {
            return entityTable.getBaseSelect();
        }
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        StringBuilder selectBuilder = new StringBuilder();
        boolean skipAlias = Map.class.isAssignableFrom(entityClass);
        for (EntityColumn entityColumn : columnList) {
            selectBuilder.append(entityColumn.getColumn());
            if (!skipAlias && !entityColumn.getColumn().equalsIgnoreCase(entityColumn.getProperty())) {
                if (entityColumn.getColumn().substring(1, entityColumn.getColumn().length() - 1).equalsIgnoreCase(entityColumn.getProperty())) {
                    selectBuilder.append(",");
                    continue;
                }
                selectBuilder.append(" AS ").append(entityColumn.getProperty()).append(",");
                continue;
            }
            selectBuilder.append(",");
        }
        entityTable.setBaseSelect(selectBuilder.substring(0, selectBuilder.length() - 1));
        return entityTable.getBaseSelect();
    }

    @Deprecated
    public static String getAllColumns(Class<?> entityClass) {
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        StringBuilder selectBuilder = new StringBuilder();
        for (EntityColumn entityColumn : columnList) {
            selectBuilder.append(entityColumn.getColumn()).append(",");
        }
        return selectBuilder.substring(0, selectBuilder.length() - 1);
    }

    @Deprecated
    public static String getPrimaryKeyWhere(Class<?> entityClass) {
        Set<EntityColumn> entityColumns = EntityHelper.getPKColumns(entityClass);
        StringBuilder whereBuilder = new StringBuilder();
        for (EntityColumn column : entityColumns) {
            whereBuilder.append(column.getColumnEqualsHolder()).append(" AND ");
        }
        return whereBuilder.substring(0, whereBuilder.length() - 4);
    }

    public static synchronized void initEntityNameMap(Class<?> entityClass, Config config) {
        Table table;
        if (entityTableMap.get(entityClass) != null) {
            return;
        }
        Style style = config.getStyle();
        if (entityClass.isAnnotationPresent(NameStyle.class)) {
            NameStyle nameStyle = entityClass.getAnnotation(NameStyle.class);
            style = nameStyle.value();
        }
        EntityTable entityTable = null;
        if (entityClass.isAnnotationPresent(Table.class) && !(table = entityClass.getAnnotation(Table.class)).name().equals("")) {
            entityTable = new EntityTable(entityClass);
            entityTable.setTable(table);
        }
        if (entityTable == null) {
            entityTable = new EntityTable(entityClass);
            entityTable.setName(StringUtil.convertByStyle(entityClass.getSimpleName(), style));
        }
        if (entityClass.isAnnotationPresent(MultiLanguage.class)) {
            entityTable.setSupportMultiLanguage(true);
        }
        entityTable.setEntityClassColumns(new LinkedHashSet<EntityColumn>());
        entityTable.setEntityClassPKColumns(new LinkedHashSet<EntityColumn>());
        List<EntityField> fields = config.isEnableMethodAnnotation() ? FieldHelper.getAll(entityClass) : FieldHelper.getFields(entityClass);
        ExtensionAttribute extensionAttribute = entityClass.getAnnotation(ExtensionAttribute.class);
        boolean useExt = extensionAttribute == null || !extensionAttribute.disable();
        for (EntityField field : fields) {
            if (!useExt && field.getName().matches("attribute(\\d+|Category)")) continue;
            EntityHelper.processField(entityTable, style, field);
        }
        if (entityTable.getEntityClassPKColumns().isEmpty()) {
            entityTable.setEntityClassPKColumns(entityTable.getEntityClassColumns());
        }
        entityTableMap.put(entityClass, entityTable);
    }

    private static void processField(final EntityTable entityTable, Style style, final EntityField field) {
        Where where;
        JoinTable[] jts;
        EntityColumn entityColumn = new EntityColumn(entityTable);
        if (field.isAnnotationPresent(Transient.class)) {
            entityColumn.setSelectable(false);
            entityColumn.setInsertable(false);
            entityColumn.setUpdatable(false);
        }
        entityColumn.setProperty(field.getName());
        entityColumn.setJavaType(field.getJavaType());
        if (entityTable.isSupportMultiLanguage()) {
            if (field.isAnnotationPresent(Id.class)) {
                JoinTable jt = new JoinTable(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return JoinTable.class;
                    }

                    @Override
                    public String name() {
                        return "multiLanguageJoin";
                    }

                    @Override
                    public boolean joinMultiLanguageTable() {
                        return true;
                    }

                    @Override
                    public Class<?> target() {
                        return entityTable.getEntityClass();
                    }

                    @Override
                    public JoinType type() {
                        return JoinType.INNER;
                    }

                    @Override
                    public JoinOn[] on() {
                        JoinOn on1 = new JoinOn(){

                            @Override
                            public Class<? extends Annotation> annotationType() {
                                return JoinOn.class;
                            }

                            @Override
                            public String joinField() {
                                return field.getName();
                            }

                            @Override
                            public String joinExpression() {
                                return "";
                            }
                        };
                        JoinOn on2 = new JoinOn(){

                            @Override
                            public Class<? extends Annotation> annotationType() {
                                return JoinOn.class;
                            }

                            @Override
                            public String joinField() {
                                return "lang";
                            }

                            @Override
                            public String joinExpression() {
                                return "#{request.locale,jdbcType=VARCHAR,javaType=java.lang.String}";
                            }
                        };
                        return new JoinOn[]{on1, on2};
                    }
                };
                entityColumn.addJoinTable(jt);
                entityTable.createAlias(EntityHelper.buildJoinKey(jt));
                entityTable.getJoinMapping().put(jt.name(), entityColumn);
            }
            if (field.isAnnotationPresent(MultiLanguageField.class)) {
                JoinColumn jc = new JoinColumn(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return JoinColumn.class;
                    }

                    @Override
                    public String joinName() {
                        return "multiLanguageJoin";
                    }

                    @Override
                    public String field() {
                        return field.getName();
                    }

                    @Override
                    public String expression() {
                        return "";
                    }
                };
                entityColumn.setJoinColumn(jc);
                entityColumn.setSelectable(true);
            }
        }
        if ((jts = (JoinTable[])field.getAnnotations(JoinTable.class)) != null) {
            for (JoinTable joinTable : jts) {
                entityColumn.addJoinTable(joinTable);
                entityTable.createAlias(EntityHelper.buildJoinKey(joinTable));
                entityTable.getJoinMapping().put(joinTable.name(), entityColumn);
            }
        }
        if (field.isAnnotationPresent(Where.class)) {
            where = field.getAnnotation(Where.class);
            entityColumn.setWhere(where);
            entityTable.getWhereColumns().add(entityColumn);
        }
        if (field.isAnnotationPresent(OrderBy.class)) {
            OrderBy orderBy = field.getAnnotation(OrderBy.class);
            if (!"".equals(orderBy.value())) {
                entityColumn.setOrderBy(orderBy.value());
            }
            entityTable.getSortColumns().add(entityColumn);
        }
        if (field.isAnnotationPresent(JoinColumn.class)) {
            JoinColumn jc = field.getAnnotation(JoinColumn.class);
            entityColumn.setJoinColumn(jc);
            entityColumn.setSelectable(true);
            entityColumn.setInsertable(false);
            entityColumn.setUpdatable(false);
        }
        if (field.isAnnotationPresent(Id.class)) {
            entityColumn.setId(true);
            entityTable.getEntityClassPKColumns().add(entityColumn);
            if (entityColumn.getWhere() == null) {
                where = new Where(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return Where.class;
                    }

                    @Override
                    public Comparison comparison() {
                        return Comparison.EQUAL;
                    }

                    @Override
                    public String expression() {
                        return "";
                    }
                };
                entityColumn.setWhere(where);
                entityTable.getWhereColumns().add(entityColumn);
            }
        }
        String columnName = null;
        if (field.isAnnotationPresent(Column.class)) {
            Column column = field.getAnnotation(Column.class);
            columnName = column.name();
            entityColumn.setUpdatable(column.updatable());
            entityColumn.setInsertable(column.insertable());
        }
        if (field.isAnnotationPresent(ColumnType.class)) {
            ColumnType columnType = field.getAnnotation(ColumnType.class);
            if (StringUtil.isEmpty(columnName) && StringUtil.isNotEmpty(columnType.column())) {
                columnName = columnType.column();
            }
            if (columnType.jdbcType() != JdbcType.UNDEFINED) {
                entityColumn.setJdbcType(columnType.jdbcType());
            }
            if (columnType.typeHandler() != UnknownTypeHandler.class) {
                entityColumn.setTypeHandler(columnType.typeHandler());
            }
        } else if (field.getJavaType() == Date.class) {
            entityColumn.setJdbcType(JdbcType.TIMESTAMP);
        }
        if (StringUtil.isEmpty(columnName)) {
            columnName = StringUtil.convertByStyle(field.getName(), style);
        }
        entityColumn.setColumn(columnName);
        if (field.isAnnotationPresent(SequenceGenerator.class)) {
            SequenceGenerator sequenceGenerator = field.getAnnotation(SequenceGenerator.class);
            if ("".equals(sequenceGenerator.sequenceName())) {
                throw new RuntimeException(entityTable.getEntityClass() + "\u5b57\u6bb5" + field.getName() + "\u7684\u6ce8\u89e3@SequenceGenerator\u672a\u6307\u5b9asequenceName!");
            }
            entityColumn.setSequenceName(sequenceGenerator.sequenceName());
        } else if (field.isAnnotationPresent(GeneratedValue.class)) {
            GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
            String generator = generatedValue.generator();
            if ("UUID".equals(generator)) {
                entityColumn.setUuid(true);
            } else if ("JDBC".equals(generator)) {
                entityColumn.setIdentity(true);
                entityColumn.setGenerator(generator);
                entityTable.setKeyProperties(entityColumn.getProperty());
                entityTable.setKeyColumns(entityColumn.getColumn());
            } else if ("SEQUENCE".equals(generator)) {
                entityColumn.setIdentity(true);
                entityColumn.setGenerator(generator);
                entityTable.setKeyProperties(entityColumn.getProperty());
                entityTable.setKeyColumns(entityColumn.getColumn());
            } else if ("IDENTITY".equals(generator) || "".equals(generator)) {
                entityColumn.setIdentity(true);
                entityColumn.setGenerator("IDENTITY");
                entityTable.setKeyProperties(entityColumn.getProperty());
                entityTable.setKeyColumns(entityColumn.getColumn());
            } else if (generatedValue.strategy() == GenerationType.IDENTITY) {
                entityColumn.setIdentity(true);
                if (!"".equals(generator)) {
                    IdentityDialect identityDialect = IdentityDialect.getDatabaseDialect(generator);
                    if (identityDialect != null) {
                        generator = identityDialect.getIdentityRetrievalStatement();
                    }
                    entityColumn.setGenerator(generator);
                }
            } else {
                throw new RuntimeException(field.getName() + " - \u8be5\u5b57\u6bb5@GeneratedValue\u914d\u7f6e\u53ea\u5141\u8bb8\u4ee5\u4e0b\u51e0\u79cd\u5f62\u5f0f:\n1.\u5168\u90e8\u6570\u636e\u5e93\u901a\u7528\u7684@GeneratedValue(generator=\"UUID\")\n2.useGeneratedKeys\u7684@GeneratedValue(generator=\"JDBC\")  \n3.useGeneratedKeys\u7684@GeneratedValue(generator=\"SEQUENCE\")  \n4.\u7c7b\u4f3cmysql\u6570\u636e\u5e93\u7684@GeneratedValue(strategy=GenerationType.IDENTITY[,generator=\"Mysql\"])");
            }
        }
        if (field.isAnnotationPresent(MultiLanguageField.class)) {
            entityColumn.setMultiLanguageField(true);
        }
        entityColumn.setCondition(field.getAnnotation(Condition.class));
        if (!field.isAnnotationPresent(Transient.class)) {
            entityTable.getEntityClassColumns().add(entityColumn);
        }
        if (entityColumn.isSelectable()) {
            entityTable.getAllColumns().add(entityColumn);
        }
    }
}

