/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.components;

import com.hand.hap.api.logs.InvokeApiStrategy;
import com.hand.hap.api.logs.dto.ApiInvokeRecord;
import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.TopicMonitor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
@TopicMonitor(channel={"api_invoke"})
public class InvokeApiManager
implements IMessageConsumer<ApiInvokeRecord>,
InitializingBean {
    public static final String API_INVOKE = "api_invoke";
    private InvokeApiStrategy invokeApiStrategy;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${api.invoke.logStrategy.class:com.hand.hap.api.logs.components.DefaultInvokeApiStrategy}")
    private String logStrategyClass;

    @Override
    public void onMessage(ApiInvokeRecord message, String pattern) {
        this.invokeApiStrategy.saveApiInvokeRecord(message);
    }

    public void afterPropertiesSet() throws Exception {
        this.invokeApiStrategy = (InvokeApiStrategy)Class.forName(this.logStrategyClass).newInstance();
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)this.invokeApiStrategy);
    }

    public InvokeApiStrategy getInvokeApiStrategy() {
        return this.invokeApiStrategy;
    }
}

