/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message;

import com.hand.hap.message.IQueueMessageListener;
import com.hand.hap.message.ITopicMessageListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.ReflectionUtils;

public class MethodReflectUtils {
    private static final Map<Class, RedisSerializer> CLASS_SERIALIZER = new HashMap<Class, RedisSerializer>();

    public static List<Method> findMethod(Class clazz, FindDesc desc) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ReflectionUtils.doWithMethods((Class)clazz, methods::add, m -> {
            if (desc.name != null && !desc.name.equals(m.getName())) {
                return false;
            }
            if (desc.modifier != 0 && (desc.modifier & m.getModifiers()) == 0) {
                return false;
            }
            if (desc.bridged != null && m.isBridge() != desc.bridged.booleanValue()) {
                return false;
            }
            if (desc.parameterCount >= 0 && desc.parameterCount != m.getParameterCount()) {
                return false;
            }
            methods.add(m);
            return true;
        });
        if (desc.failOnNotFound && methods.isEmpty()) {
            throw new RuntimeException("can not found suitable method on class:" + clazz);
        }
        return methods;
    }

    public static RedisSerializer getProperRedisSerializer(Class<?> clazz) {
        Object rs = CLASS_SERIALIZER.get(clazz);
        if (rs == null) {
            rs = clazz == String.class ? new StringRedisSerializer() : new Jackson2JsonRedisSerializer(clazz);
            CLASS_SERIALIZER.put(clazz, (RedisSerializer)rs);
        }
        return rs;
    }

    public static String getTopicMethodName(String mn, Object target) {
        if (StringUtils.isBlank((String)mn)) {
            mn = target instanceof ITopicMessageListener ? "onTopicMessage" : "onMessage";
        }
        return mn;
    }

    public static String getQueueMethodName(String mn, Object target) {
        if (StringUtils.isBlank((String)mn)) {
            mn = target instanceof IQueueMessageListener ? "onQueueMessage" : "onMessage";
        }
        return mn;
    }

    public static final class FindDesc {
        private String name;
        private int modifier = 1;
        private Boolean bridged = Boolean.FALSE;
        private boolean failOnNotFound = false;
        private int parameterCount = -1;

        public FindDesc(String name) {
            this.name = name;
        }

        public FindDesc(String name, int pc) {
            this.name = name;
            this.parameterCount = pc;
        }

        public FindDesc withModifier(int mod) {
            this.modifier = mod;
            return this;
        }

        public FindDesc bridged(Boolean b) {
            this.bridged = b;
            return this;
        }

        public FindDesc paramsCount(int pc) {
            this.parameterCount = pc;
            return this;
        }

        public FindDesc failOnNotFound(boolean fonf) {
            this.failOnNotFound = fonf;
            return this;
        }
    }
}

